/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.servlets.vomses;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.glite.security.voms.admin.error.VOMSException;
import org.glite.security.voms.admin.servlets.VOMSContextListener;
import org.glite.security.voms.admin.util.AdminServiceContactUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VOMSESContextListener
implements ServletContextListener {
    static final Logger log = LoggerFactory.getLogger(VOMSContextListener.class);
    private static final String CONFDIR_KEY = "confdir";
    public static final String VERSION_KEY = "version";
    public static final String ENDPOINTS_KEY = "endpoints";

    private void initVersion(ServletContextEvent sce) {
        InputStream versionPropStream = this.getClass().getClassLoader().getResourceAsStream("version.properties");
        Properties versionProps = new Properties();
        try {
            versionProps.load(versionPropStream);
        }
        catch (IOException e) {
            log.error("Error loading version properties: " + e.getMessage(), (Throwable)e);
            throw new VOMSException(e);
        }
        sce.getServletContext().setAttribute(VERSION_KEY, versionProps.get("voms-admin.server.version"));
    }

    private void initEndpoints(ServletContextEvent sce) {
        List<Object> endpoints = new ArrayList();
        String confDir = sce.getServletContext().getInitParameter(CONFDIR_KEY);
        log.info("Loading VOMS service endpoints from {}", (Object)confDir);
        endpoints = AdminServiceContactUtil.getAdminServiceContactInfo(confDir);
        Collections.sort(endpoints);
        log.debug("Endpoint information loaded: {}", endpoints);
        sce.getServletContext().setAttribute(ENDPOINTS_KEY, endpoints);
    }

    public void contextInitialized(ServletContextEvent sce) {
        log.info("VOMSES webapp starting...");
        this.initVersion(sce);
        this.initEndpoints(sce);
        sce.getServletContext().setAttribute("host", (Object)sce.getServletContext().getInitParameter("host"));
        log.info("VOMSES succesfully initialized.");
    }

    public void contextDestroyed(ServletContextEvent sce) {
        log.info("VOMSES webapp stopped.");
    }
}

