/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.servlets.vomses;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glite.security.voms.admin.util.AdminServiceContactInfo;

public class RedirectServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected String getVONameFromContextPath(String contextPath) {
        String path = contextPath.substring(1);
        int nextSlashIndex = path.indexOf(47);
        if (nextSlashIndex > 0) {
            path = path.substring(0, nextSlashIndex);
        }
        return path;
    }

    protected String getRedirectFromVOConfiguration(HttpServletRequest req) {
        List endpoints = (List)req.getServletContext().getAttribute("endpoints");
        if (req.getPathInfo() == null) {
            return "/";
        }
        String voName = this.getVONameFromContextPath(req.getPathInfo());
        for (AdminServiceContactInfo e : endpoints) {
            if (!e.getVoName().equals(voName)) continue;
            StringBuilder url = new StringBuilder(String.format("%s%s", e.getBaseURL(), req.getRequestURI()));
            if (req.getQueryString() != null) {
                url.append("?" + req.getQueryString());
            }
            return url.toString();
        }
        return null;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String url = this.getRedirectFromVOConfiguration(req);
        if (url != null) {
            resp.sendRedirect(url);
        }
        super.doGet(req, resp);
    }
}

