/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.servlets;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.glite.security.voms.admin.configuration.VOMSConfigurationException;
import org.glite.security.voms.admin.error.VOMSFatalException;
import org.glite.security.voms.admin.util.ExceptionUtils;
import org.glite.security.voms.admin.util.SysconfigUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiblingsContextListener
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(SiblingsContextListener.class);

    public void contextDestroyed(ServletContextEvent ev) {
    }

    public void contextInitialized(ServletContextEvent ev) {
        try {
            this.findConfiguredVOs(ev);
            this.loadVersionProperties(ev);
            this.configureLogging(ev);
            log.info("Siblings context initialized.");
        }
        catch (IOException e) {
            throw new RuntimeException("Error configuring loggin system!", e);
        }
    }

    protected void configureLogging(ServletContextEvent ev) throws IOException {
        InputStream is = ev.getServletContext().getResourceAsStream("/WEB-INF/classes/logback.siblings.xml");
        if (is == null) {
            throw new VOMSConfigurationException("Error configuring logging! Logback configuration file not found in context!");
        }
        try {
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)lc);
            lc.reset();
            configurator.doConfigure(is);
        }
        catch (JoranException e) {
            ExceptionUtils.logError(log, e);
            throw new VOMSConfigurationException("Error configuring logging system: " + e.getMessage(), e);
        }
    }

    public void loadVersionProperties(ServletContextEvent ev) throws IOException {
        Properties versionProps = new Properties();
        InputStream is = ev.getServletContext().getResourceAsStream("/WEB-INF/classes/version.properties");
        versionProps.load(is);
        ev.getServletContext().setAttribute("version", versionProps.get("voms-admin.server.version"));
    }

    public void findConfiguredVOs(ServletContextEvent ev) {
        Properties sysconfigProps = SysconfigUtil.loadSysconfig();
        String configDirPath = sysconfigProps.getProperty("CONF_DIR");
        if (configDirPath == null) {
            throw new VOMSFatalException("CONF_DIR undefined in VOMS sysconfig!");
        }
        ArrayList<String> voList = new ArrayList<String>();
        File configDir = new File(configDirPath);
        if (!configDir.exists()) {
            throw new RuntimeException("Voms configuration directory does not exist");
        }
        File[] filez = configDir.listFiles();
        if (filez != null) {
            for (int i = 0; i < filez.length; ++i) {
                if (!filez[i].isDirectory()) continue;
                log.debug("Found vo: " + filez[i].getName());
                voList.add(filez[i].getName());
            }
        }
        ev.getServletContext().setAttribute("configuredVOs", voList);
    }
}

