/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.servlets;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.operations.CurrentAdmin;
import org.glite.security.voms.admin.servlets.InitSecurityContext;
import org.italiangrid.utils.voms.SecurityContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityContextFilter
implements Filter {
    public static final String SECURITY_CONTEXT_SESSION_KEY = "voms-admin-security-context";
    public static final int SESSION_LIFETIME_IN_SECONDS = 600;
    protected Logger log = LoggerFactory.getLogger(SecurityContextFilter.class);

    public void init(FilterConfig arg0) throws ServletException {
        this.log.debug("Initializing SecurityContextFilter {}", (Object)this);
    }

    protected void initContext(HttpServletRequest request) {
        HttpSession s = request.getSession(true);
        s.setMaxInactiveInterval(600);
        SecurityContextImpl sc = (SecurityContextImpl)s.getAttribute(SECURITY_CONTEXT_SESSION_KEY);
        if (sc == null) {
            InitSecurityContext.setContextFromRequest((ServletRequest)request);
            s.setAttribute(SECURITY_CONTEXT_SESSION_KEY, (Object)SecurityContextImpl.getCurrentContext());
            InitSecurityContext.logConnection();
        } else {
            SecurityContextImpl.setCurrentContext((SecurityContextImpl)sc);
        }
    }

    protected void initWebappProperties(HttpServletRequest request) {
        String voName = VOMSConfiguration.instance().getVOName();
        request.setAttribute("voName", (Object)voName);
        request.setAttribute("currentAdmin", (Object)CurrentAdmin.instance());
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        this.log.debug("Executing SecurityContextFilter {}", (Object)this);
        HttpServletRequest request = (HttpServletRequest)req;
        this.initContext(request);
        this.initWebappProperties(request);
        chain.doFilter(req, res);
    }

    public void destroy() {
        this.log.debug("Destroying SecurityContextFilter {}", (Object)this);
    }
}

