/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.servlets;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import javax.servlet.ServletRequest;
import org.glite.security.voms.admin.error.VOMSException;
import org.italiangrid.utils.voms.SecurityContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitSecurityContext {
    protected static Logger log = LoggerFactory.getLogger(InitSecurityContext.class);

    public static void setContextFromRequest(ServletRequest req) {
        log.debug("Creating a new security context");
        SecurityContextImpl sc = new SecurityContextImpl();
        String remote = req.getRemoteAddr();
        sc.setRemoteAddr(remote);
        X509Certificate[] cert = null;
        try {
            cert = (X509Certificate[])req.getAttribute("javax.servlet.request.X509Certificate");
        }
        catch (Throwable t) {
            throw new VOMSException(t.getMessage(), t);
        }
        if (cert == null) {
            sc.setClientName("/O=VOMS/O=System/CN=Unauthenticated Client");
            sc.setIssuerName("/O=VOMS/O=System/CN=Dummy Certificate Authority");
        } else {
            sc.setClientCertChain(cert);
            if (sc.getClientName() != null && sc.getClientName().startsWith("/O=VOMS/O=System")) {
                log.error("Client name starts with internal prefix, discarding credentials: " + sc.getClientName());
                sc.setClientName("/O=VOMS/O=System/CN=Unauthenticated Client");
                sc.setIssuerName("/O=VOMS/O=System/CN=Dummy Certificate Authority");
            } else if (sc.getIssuerName() != null && sc.getIssuerName().startsWith("/O=VOMS/O=System")) {
                log.error("Client issuer starts with internal prefix, discarding credentials: " + sc.getClientName());
                sc.setClientName("/O=VOMS/O=System/CN=Unauthenticated Client");
                sc.setIssuerName("/O=VOMS/O=System/CN=Dummy Certificate Authority");
            }
        }
        SecurityContextImpl.setCurrentContext((SecurityContextImpl)sc);
    }

    public static void logConnection() {
        SecurityContextImpl sc = SecurityContextImpl.getCurrentContext();
        if (sc.getClientCert() == null) {
            log.info("Unauthenticated connection from \"{}\"", (Object)sc.getRemoteAddr());
        } else {
            String clientName = sc.getClientName();
            String issuerName = sc.getIssuerName();
            BigInteger sn = sc.getClientCert().getSerialNumber();
            String serialNumber = sn == null ? "NULL" : sn.toString();
            log.info("Connection from \"" + sc.getRemoteAddr() + "\" by " + clientName + " (issued by \"" + issuerName + "\", " + "serial " + serialNumber + ")");
        }
    }

    public static void setClearContext() {
        log.info("Clearing the security context");
        SecurityContextImpl sc = new SecurityContextImpl();
        SecurityContextImpl.setCurrentContext((SecurityContextImpl)sc);
        sc.setClientName("/O=VOMS/O=System/CN=Unauthenticated Client");
        sc.setIssuerName("/O=VOMS/O=System/CN=Dummy Certificate Authority");
    }
}

