/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.servlets;

import javax.servlet.http.HttpServletRequest;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.error.VOMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSRFGuard {
    public static final Logger log = LoggerFactory.getLogger(CSRFGuard.class);
    public static final String CSRF_GUARD_HEADER_NAME = "X-VOMS-CSRF-GUARD";

    public static void checkCSRFGuard(HttpServletRequest request) {
        boolean csrfGuardLogOnly = VOMSConfiguration.instance().getBoolean("voms.csrf.log_only", false);
        if (request.getHeader(CSRF_GUARD_HEADER_NAME) == null) {
            log.warn("Incoming request from {}:{} is missing CSRF prevention HTTP header", (Object)request.getRemoteAddr(), (Object)request.getRemotePort());
            if (!csrfGuardLogOnly) {
                throw new VOMSException("CSRF header guard missing from request!");
            }
        }
    }
}

