/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.service;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.error.NullArgumentException;
import org.glite.security.voms.admin.error.VOMSException;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.persistence.dao.VOMSAdminDAO;
import org.glite.security.voms.admin.persistence.model.ACL;
import org.glite.security.voms.admin.persistence.model.Certificate;
import org.glite.security.voms.admin.persistence.model.VOMSAdmin;
import org.glite.security.voms.admin.persistence.model.VOMSAttributeDescription;
import org.glite.security.voms.admin.persistence.model.VOMSBaseAttribute;
import org.glite.security.voms.admin.persistence.model.VOMSCA;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.service.acl.ACLEntry;
import org.glite.security.voms.service.attributes.AttributeClass;
import org.glite.security.voms.service.attributes.AttributeValue;

public class ServiceUtils {
    public static AttributeValue[] toAttributeValueArray(Collection attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return null;
        }
        AttributeValue[] values = new AttributeValue[attributes.size()];
        Iterator i = attributes.iterator();
        int index = 0;
        while (i.hasNext()) {
            values[index++] = ((VOMSBaseAttribute)i.next()).asAttributeValue();
        }
        return values;
    }

    public static AttributeClass[] toAttributeClassArray(List descriptions) {
        if (descriptions == null || descriptions.isEmpty()) {
            return null;
        }
        AttributeClass[] classes = new AttributeClass[descriptions.size()];
        Iterator i = descriptions.iterator();
        int index = 0;
        while (i.hasNext()) {
            classes[index++] = ((VOMSAttributeDescription)i.next()).asAttributeClass();
        }
        return classes;
    }

    public static String[] rolesToStringArray(Collection c) {
        if (c == null || c.isEmpty()) {
            return null;
        }
        String[] res = new String[c.size()];
        int index = 0;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            res[index++] = i.next().toString();
        }
        return res;
    }

    public static String[] groupsToStringArray(Collection c) {
        if (c == null || c.isEmpty()) {
            return null;
        }
        String[] res = new String[c.size()];
        int index = 0;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            res[index++] = ((VOMSGroup)i.next()).getName();
        }
        return res;
    }

    public static String[] casToStringArray(Collection c) {
        if (c == null || c.isEmpty()) {
            return null;
        }
        String[] res = new String[c.size()];
        int index = 0;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            res[index++] = ((VOMSCA)i.next()).getSubjectString();
        }
        return res;
    }

    public static String[] toStringArray(Collection c) {
        if (c == null || c.isEmpty()) {
            return null;
        }
        String[] res = new String[c.size()];
        int index = 0;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            res[index++] = i.next().toString();
        }
        return res;
    }

    public static ACLEntry[] toACLEntryArray(ACL acl) {
        if (acl == null || acl.getPermissions().isEmpty()) {
            return null;
        }
        ACLEntry[] entries = new ACLEntry[acl.getPermissions().size()];
        int index = 0;
        for (VOMSAdmin admin : acl.getPermissions().keySet()) {
            VOMSPermission perms = acl.getPermissions(admin);
            ACLEntry entry = new ACLEntry();
            entry.setAdminSubject(admin.getDn());
            entry.setAdminIssuer(admin.getCa().getDn());
            entry.setVomsPermissionBits(perms.getBits());
            entries[index++] = entry;
        }
        return entries;
    }

    public static void limitUnauthenticatedClientPermissions(VOMSAdmin admin, VOMSPermission perms) {
        if (admin.isUnauthenticated()) {
            VOMSPermission permMask = VOMSConfiguration.instance().getUnauthenticatedClientPermissionMask();
            perms.limitToPermissions(permMask);
        }
    }

    public static Map<VOMSAdmin, VOMSPermission> toPermissionMap(ACLEntry[] entries) {
        if (entries == null || entries.length == 0) {
            throw new NullArgumentException("entries cannot be null or empty!");
        }
        HashMap<VOMSAdmin, VOMSPermission> map = new HashMap<VOMSAdmin, VOMSPermission>();
        for (ACLEntry e : entries) {
            VOMSAdmin admin = VOMSAdminDAO.instance().getByName(e.getAdminSubject(), e.getAdminIssuer());
            VOMSPermission perm = VOMSPermission.fromBits(e.getVomsPermissionBits());
            if (admin == null) continue;
            ServiceUtils.limitUnauthenticatedClientPermissions(admin, perm);
            map.put(admin, perm);
        }
        return map;
    }

    public static org.glite.security.voms.service.certificates.X509Certificate toX509Certificate(Certificate c) {
        org.glite.security.voms.service.certificates.X509Certificate cert = new org.glite.security.voms.service.certificates.X509Certificate();
        cert.setId(c.getId());
        cert.setSubject(c.getSubjectString());
        cert.setIssuer(c.getCa().getSubjectString());
        return cert;
    }

    public static org.glite.security.voms.service.certificates.X509Certificate[] toX509CertificateArray(Set<Certificate> certificateSet) {
        org.glite.security.voms.service.certificates.X509Certificate[] certs = new org.glite.security.voms.service.certificates.X509Certificate[certificateSet.size()];
        int counter = 0;
        for (Certificate c : certificateSet) {
            certs[counter++] = ServiceUtils.toX509Certificate(c);
        }
        return certs;
    }

    public static List<String> decorateDNList(List<String> l) {
        ArrayList<String> returnValue = new ArrayList<String>();
        for (String dn : l) {
            if (!dn.contains("Email")) continue;
            returnValue.add(dn.replaceAll("Email=", "emailAddress="));
        }
        returnValue.addAll(l);
        return returnValue;
    }

    public static String getBaseContext(HttpServletRequest request) {
        String result = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + "/voms/" + VOMSConfiguration.instance().getVOName();
        return result;
    }

    public static X509Certificate certificateFromBytes(byte[] certBytes) {
        CertificateFactory cf;
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new VOMSException("Error instantiating X.509 Certificate factory!", e);
        }
        X509Certificate x509Cert = null;
        try {
            x509Cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certBytes));
        }
        catch (CertificateException e) {
            throw new VOMSException("Error parsing X.509 certificate passed as argument!", e);
        }
        return x509Cert;
    }

    public static List<String> toStringList(String[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>();
        for (String s : array) {
            l.add(s);
        }
        return l;
    }
}

