/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.service;

import org.glite.security.voms.admin.persistence.HibernateFactory;
import org.hibernate.JDBCException;
import org.slf4j.Logger;

public class ServiceExceptionHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleServiceException(Logger log, RuntimeException t) {
        if (t instanceof JDBCException) {
            Throwable cause = t.getCause();
            log.error("Database error caught: " + cause.getMessage());
            if (log.isDebugEnabled()) {
                log.error("Database error caught: " + cause.getMessage(), (Throwable)t);
            }
            try {
                HibernateFactory.rollbackTransaction();
            }
            finally {
                HibernateFactory.closeSession();
            }
        } else if (log.isDebugEnabled()) {
            log.error(t.getClass().getSimpleName() + " exception caught: ", (Throwable)t);
        } else {
            log.error(t.getClass().getSimpleName() + " exception caught: " + t.getMessage());
        }
        throw t;
    }
}

