/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.server.vomses;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.ValidationErrorListener;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.webapp.WebAppContext;
import org.glite.security.voms.admin.util.SysconfigUtil;
import org.italiangrid.utils.https.JettyRunThread;
import org.italiangrid.utils.https.SSLOptions;
import org.italiangrid.utils.https.ServerFactory;
import org.italiangrid.utils.https.impl.canl.CANLListener;
import org.italiangrid.voms.util.CertificateValidatorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VomsesMain {
    private static final Logger log = LoggerFactory.getLogger(VomsesMain.class);
    private Options cliOptions;
    private CommandLineParser parser = new GnuParser();
    private String confDir;
    private String host;
    private String port;
    private String shutdownPort;
    private String shutdownPassword;
    private String certFile;
    private String keyFile;
    private String trustDir;
    private Server server;
    private WebAppContext context;
    private int trustDirRefreshIntervalInMsec = 600000;

    private void configureLogging() {
        URL loggingConf = this.getClass().getClassLoader().getResource("logback.vomses.xml");
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)lc);
        lc.reset();
        try {
            configurator.doConfigure(loggingConf);
        }
        catch (JoranException e) {
            this.failAndExit("Error setting up the logging system", e);
        }
    }

    private void failAndExit(String errorMessage, Throwable t) {
        if (t != null) {
            System.err.format("%s: %s\n", errorMessage, t.getMessage());
            t.printStackTrace(System.err);
        } else {
            System.err.println(errorMessage);
        }
        System.exit(1);
    }

    private void initOptions() {
        this.cliOptions = new Options();
        for (OptionArgs o : OptionArgs.values()) {
            this.cliOptions.addOption(null, o.getOptionName(), true, o.getDescription());
        }
    }

    public VomsesMain(String[] args) {
        try {
            this.initOptions();
            this.parseCommandLineOptions(args);
            this.configureLogging();
            this.logConfiguration();
            this.configureJettyServer();
            this.start();
        }
        catch (Throwable t) {
            this.failAndExit("Error starting up VOMSES application", t);
        }
    }

    private void configureJettyServer() {
        SSLOptions options = this.getSSLOptions();
        CANLListener l = new CANLListener();
        X509CertChainValidatorExt validator = CertificateValidatorBuilder.buildCertificateValidator((String)options.getTrustStoreDirectory(), (ValidationErrorListener)l, (StoreUpdateListener)l, (long)options.getTrustStoreRefreshIntervalInMsec());
        this.server = ServerFactory.newServer((String)this.host, (int)Integer.parseInt(this.port), (SSLOptions)options, (X509CertChainValidatorExt)validator, (int)50, (int)10);
        this.configureWebapp();
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{this.context});
        this.server.setHandler((Handler)handlers);
    }

    private void checkStatus() throws Throwable {
        if (this.context.getUnavailableException() != null) {
            throw this.context.getUnavailableException();
        }
    }

    private void configureWebapp() {
        String webappResourceDir = this.getClass().getClassLoader().getResource("vomses-webapp").toExternalForm();
        this.context = new WebAppContext();
        this.context.setContextPath("/");
        this.context.setResourceBase(webappResourceDir);
        this.context.setParentLoaderPriority(true);
        this.context.setInitParameter("confdir", this.confDir);
        this.context.setInitParameter("host", this.host);
        this.context.setThrowUnavailableOnStartupException(true);
    }

    protected SSLOptions getSSLOptions() {
        SSLOptions options = new SSLOptions();
        options.setCertificateFile(this.certFile);
        options.setKeyFile(this.keyFile);
        options.setTrustStoreDirectory(this.trustDir);
        options.setTrustStoreRefreshIntervalInMsec((long)this.trustDirRefreshIntervalInMsec);
        options.setNeedClientAuth(false);
        options.setWantClientAuth(false);
        return options;
    }

    private void parseCommandLineOptions(String[] args) {
        try {
            CommandLine cmdLine = this.parser.parse(this.cliOptions, args);
            Properties sysconfigProperties = SysconfigUtil.loadSysconfig();
            this.confDir = cmdLine.getOptionValue(OptionArgs.CONFDIR.getOptionName());
            if (this.confDir == null) {
                this.confDir = sysconfigProperties.getProperty("CONF_DIR");
            }
            this.host = cmdLine.getOptionValue(OptionArgs.HOST.getOptionName(), "localhost");
            this.port = cmdLine.getOptionValue(OptionArgs.PORT.getOptionName(), "8443");
            this.shutdownPort = cmdLine.getOptionValue(OptionArgs.SHUTDOWN_PORT.getOptionName(), "9000");
            this.certFile = cmdLine.getOptionValue(OptionArgs.CERT.getOptionName(), "/etc/grid-security/hostcert.pem");
            this.keyFile = cmdLine.getOptionValue(OptionArgs.KEY.getOptionName(), "/etc/grid-security/hostkey.pem");
            this.trustDir = cmdLine.getOptionValue(OptionArgs.TRUSTDIR.getOptionName(), "/etc/grid-security/certificates");
        }
        catch (ParseException e) {
            this.failAndExit("Error parsing command line arguments", e);
        }
    }

    private void logConfiguration() {
        log.info("VOMSES startup configuration:");
        log.info("host: {}", (Object)this.host);
        log.info("port: {}", (Object)this.port);
        log.info("certFile: {}", (Object)this.certFile);
        log.info("keyFile: {}", (Object)this.keyFile);
        log.info("trustDir: {}", (Object)this.trustDir);
    }

    private void start() {
        JettyRunThread service = new JettyRunThread(this.server);
        try {
            service.start();
            this.checkStatus();
            service.join();
        }
        catch (Throwable t) {
            this.failAndExit("Error starting VOMSES service", t);
        }
    }

    public static void main(String[] args) {
        new VomsesMain(args);
    }

    static enum OptionArgs {
        HOST("host", "The host where the service is running", true),
        PORT("port", "The service will listen on this port", true),
        SHUTDOWN_PORT("shutdown_port", "The service can be shut down contacting this port.", false),
        CERT("cert", "The certificate used to setup the SSL context."),
        KEY("key", "The key used to setup the SSL context."),
        TRUSTDIR("trustdir", "The directory where IGTF trust anchors are found."),
        CONFDIR("confdir", "The directory where VOMS Admin configuration lives.");

        private final String optionName;
        private final String description;
        private final boolean required;

        private OptionArgs(String optionName, String desc) {
            this(optionName, desc, false);
        }

        private OptionArgs(String optionName, String desc, boolean required) {
            this.optionName = optionName;
            this.description = desc;
            this.required = required;
        }

        public synchronized String getOptionName() {
            return this.optionName;
        }

        public synchronized String getDescription() {
            return this.description;
        }

        public synchronized boolean isRequired() {
            return this.required;
        }

        public String toString() {
            return this.optionName;
        }
    }
}

