/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.server;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.ValidationErrorListener;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import java.io.File;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.webapp.WebAppContext;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.util.SysconfigUtil;
import org.italiangrid.utils.https.JettyAdminService;
import org.italiangrid.utils.https.JettyRunThread;
import org.italiangrid.utils.https.JettyShutdownTask;
import org.italiangrid.utils.https.SSLOptions;
import org.italiangrid.utils.https.ServerFactory;
import org.italiangrid.utils.https.impl.canl.CANLListener;
import org.italiangrid.voms.util.CertificateValidatorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    public static final Logger log = LoggerFactory.getLogger(Main.class);
    public static final String DEFAULT_WAR = "/usr/share/webapps/voms-admin.war";
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_PORT = "15000";
    public static final String DEFAULT_SHUTDOWN_PORT = "15001";
    public static final String DEFAULT_CERT = "/etc/grid-security/hostcert.pem";
    public static final String DEFAULT_KEY = "/etc/grid-security/hostkey.pem";
    public static final String DEFAULT_TRUSTSTORE_DIR = "/etc/grid-security/certificates";
    public static final String DEFAULT_TMP_PREFIX = "/var/tmp";
    public static final long DEFAULT_TRUSTSTORE_REFRESH_INTERVAL = 60000L;
    public static final int DEFAULT_MAX_CONNECTIONS = 50;
    public static final int DEFAULT_MAX_REQUEST_QUEUE_SIZE = 200;
    private static final String ARG_WAR = "war";
    private static final String ARG_WAR_DIR = "wardir";
    private static final String ARG_VO = "vo";
    private static final String ARG_CONFDIR = "confdir";
    private Options cliOptions;
    private CommandLineParser parser = new GnuParser();
    private String war;
    private String warDirectory;
    private String vo;
    private String confDir;
    private String host;
    private String port;
    private String shutdownPort;
    private String shutdownPassword;
    private String certFile;
    private String keyFile;
    private String trustDir;
    private long trustDirRefreshIntervalInMsec;
    private Server server;
    private JettyAdminService shutdownService;
    private WebAppContext vomsWebappContext;
    private File jettyTmpDir;

    private void initOptions() {
        this.cliOptions = new Options();
        this.cliOptions.addOption(ARG_WAR, true, "The WAR used to start this server.");
        this.cliOptions.addOption(ARG_WAR_DIR, true, "The directory where the unpacked VOMS Admin war lives.");
        this.cliOptions.addOption(ARG_CONFDIR, true, "The configuration directory where VOMS configuration is stored.");
        Option voOption = new Option(ARG_VO, true, "The VO this server will run for.");
        voOption.setRequired(true);
        this.cliOptions.addOption(voOption);
    }

    private void failAndExit(String errorMessage, Throwable t) {
        if (t != null) {
            System.err.format("%s: %s\n", errorMessage, t.getMessage());
        } else {
            System.err.println(errorMessage);
        }
        System.exit(1);
    }

    private void checkStartupConfiguration() {
        File warFile;
        if (!(this.warDirectory != null || (warFile = new File(this.war)).canRead() && warFile.isFile())) {
            log.error("Web archive file is not readable or is not a regular file!");
            System.exit(1);
        }
    }

    private void parseCommandLineOptions(String[] args) {
        try {
            CommandLine cmdLine = this.parser.parse(this.cliOptions, args);
            Properties sysconfigProperties = SysconfigUtil.loadSysconfig();
            String installationPrefix = SysconfigUtil.getInstallationPrefix();
            String defaultPrefixedWarPath = String.format("%s/%s", installationPrefix, DEFAULT_WAR).replaceAll("/+", "/");
            this.war = cmdLine.getOptionValue(ARG_WAR, defaultPrefixedWarPath);
            this.warDirectory = cmdLine.getOptionValue(ARG_WAR_DIR);
            this.vo = cmdLine.getOptionValue(ARG_VO);
            this.confDir = cmdLine.getOptionValue(ARG_CONFDIR);
            if (this.confDir == null) {
                this.confDir = sysconfigProperties.getProperty("CONF_DIR");
            }
            System.setProperty("voms.vo.name", this.vo);
        }
        catch (ParseException e) {
            this.failAndExit("Error parsing command line arguments", e);
        }
    }

    private void configureLogging() {
        String loggingConf = String.format("%s/%s/%s", this.confDir, this.vo, "logback.xml");
        File f = new File(loggingConf);
        if (!f.exists()) {
            this.failAndExit(String.format("Logging configuration not found at path '%s'", loggingConf), null);
        }
        if (!f.canRead()) {
            this.failAndExit(String.format("Logging configuration is not readable: '%s'", loggingConf), null);
        }
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)lc);
        lc.reset();
        try {
            configurator.doConfigure(f);
        }
        catch (JoranException e) {
            this.failAndExit("Error setting up the logging system", e);
        }
    }

    private void loadConfiguration() {
        VOMSConfiguration conf = VOMSConfiguration.load(null);
        conf.loadServiceProperties();
        this.host = conf.getString("voms.hostname", DEFAULT_HOST);
        this.port = conf.getString("voms.port", DEFAULT_PORT);
        this.shutdownPort = conf.getString("voms.shutdown_port", DEFAULT_SHUTDOWN_PORT);
        this.shutdownPassword = conf.getString("voms.shutdown_password", null);
        this.certFile = conf.getString("voms.service.cert", DEFAULT_CERT);
        this.keyFile = conf.getString("voms.service.key", DEFAULT_KEY);
        this.trustDir = conf.getString("voms.trust_anchors.dir");
        this.trustDirRefreshIntervalInMsec = conf.getLong("voms.trust_anchors.refresh_period", 60000L);
        VOMSConfiguration.dispose();
    }

    private void logStartupConfiguration() {
        log.info("Starting VOMS web services for VO {} binding on {}:{}", new Object[]{this.vo, this.host, this.port});
        if (this.warDirectory != null) {
            log.info("Unpacked web archive location: {}", (Object)this.warDirectory);
        } else {
            log.info("Web archive location: {}", (Object)this.war);
        }
        log.info("Service credentials: {}, {}", (Object)this.certFile, (Object)this.keyFile);
        log.info("Trust anchors directory: {}", (Object)this.trustDir);
        log.info("Trust anchors directory refresh interval (in msecs): {}", (Object)this.trustDirRefreshIntervalInMsec);
        log.info("Jetty temporary directory: {}", (Object)this.jettyTmpDir.toString());
    }

    public Main(String[] args) {
        try {
            this.initOptions();
            this.parseCommandLineOptions(args);
            this.configureLogging();
        }
        catch (Throwable t) {
            System.err.println("Error starting voms-admin server: " + t.getMessage());
            t.printStackTrace(System.err);
            System.exit(1);
        }
        try {
            this.loadConfiguration();
            this.initJettyTmpDir();
            this.logStartupConfiguration();
            this.checkStartupConfiguration();
            this.configureJettyServer();
            this.configureShutdownService();
            this.start();
        }
        catch (Throwable t) {
            log.error("Error starting voms-admin server:" + t.getMessage(), t);
            System.exit(1);
        }
    }

    protected void initJettyTmpDir() {
        String baseDirPath = String.format("%s/%s/%s", DEFAULT_TMP_PREFIX, "voms-webapp", this.vo).replaceAll("/+", "/");
        File basePath = new File(baseDirPath);
        if (!basePath.exists()) {
            basePath.mkdirs();
        }
        this.jettyTmpDir = basePath;
    }

    protected SSLOptions getSSLOptions() {
        SSLOptions options = new SSLOptions();
        options.setCertificateFile(this.certFile);
        options.setKeyFile(this.keyFile);
        options.setTrustStoreDirectory(this.trustDir);
        options.setTrustStoreRefreshIntervalInMsec(this.trustDirRefreshIntervalInMsec);
        return options;
    }

    protected void setupVOName() {
        System.setProperty("VO_NAME", this.vo);
    }

    protected void configureWebApp() {
        this.vomsWebappContext = new WebAppContext();
        this.vomsWebappContext.setContextPath(String.format("/voms/%s", this.vo));
        this.vomsWebappContext.setTempDirectory(this.jettyTmpDir);
        if (this.warDirectory != null) {
            String webXMLPath = String.format("%s/WEB-INF/web.xml", this.warDirectory);
            this.vomsWebappContext.setDescriptor(webXMLPath);
            this.vomsWebappContext.setResourceBase(this.warDirectory);
        } else {
            this.vomsWebappContext.setWar(this.war);
        }
        this.vomsWebappContext.setParentLoaderPriority(true);
        this.vomsWebappContext.setInitParameter("VO_NAME", this.vo);
        this.vomsWebappContext.setInitParameter("CONF_DIR", this.confDir);
    }

    protected void configureJettyServer() {
        SSLOptions options = this.getSSLOptions();
        CANLListener l = new CANLListener();
        X509CertChainValidatorExt validator = CertificateValidatorBuilder.buildCertificateValidator((String)options.getTrustStoreDirectory(), (ValidationErrorListener)l, (StoreUpdateListener)l, (long)options.getTrustStoreRefreshIntervalInMsec());
        this.server = ServerFactory.newServer((String)this.host, (int)Integer.parseInt(this.port), (SSLOptions)this.getSSLOptions(), (X509CertChainValidatorExt)validator, (int)50, (int)200);
        this.configureWebApp();
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{this.vomsWebappContext});
        this.server.setHandler((Handler)handlers);
    }

    protected void configureShutdownService() {
        this.shutdownService = new JettyAdminService(DEFAULT_HOST, Integer.parseInt(this.shutdownPort), this.shutdownPassword);
        this.shutdownService.registerShutdownTask((Runnable)new JettyShutdownTask(this.server));
    }

    private void checkStatus() throws Throwable {
        if (this.vomsWebappContext.getUnavailableException() != null) {
            throw this.vomsWebappContext.getUnavailableException();
        }
    }

    private void start() {
        JettyRunThread vomsService = new JettyRunThread(this.server);
        vomsService.start();
        try {
            this.checkStatus();
            this.shutdownService.start();
        }
        catch (Throwable t) {
            log.error("Error starting VOMS admin server: {}", (Object)t.getClass().getName(), (Object)t);
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        new Main(args);
    }
}

