/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.model.task;

import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.glite.security.voms.admin.persistence.model.VOMSAdmin;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.glite.security.voms.admin.persistence.model.task.LogRecord;
import org.glite.security.voms.admin.persistence.model.task.TaskType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Sort;
import org.hibernate.annotations.SortType;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="task")
public abstract class Task {
    @Id
    @Column(name="task_id")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="VOMS_TASK_SEQ")
    @SequenceGenerator(name="VOMS_TASK_SEQ", sequenceName="VOMS_TASK_SEQ")
    Long id;
    @ManyToOne(optional=false)
    @JoinColumn(name="task_type_id", nullable=false, updatable=false)
    TaskType type;
    Date creationDate;
    Date expiryDate;
    Date completionDate;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    TaskStatus status;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="task")
    @Sort(type=SortType.NATURAL)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    SortedSet<LogRecord> logRecords = new TreeSet<LogRecord>();
    @ManyToOne
    @JoinColumn(name="usr_id")
    VOMSUser user;
    @ManyToOne
    @JoinColumn(name="admin_id")
    VOMSAdmin admin;

    public Long getId() {
        return this.id;
    }

    public TaskType getType() {
        return this.type;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setType(TaskType typeInfo) {
        this.type = typeInfo;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public TaskStatus getStatus() {
        return this.status;
    }

    public void setStatus(TaskStatus status) {
        this.status = status;
    }

    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    public Date getCompletionDate() {
        return this.completionDate;
    }

    public void setCompletionDate(Date completionDate) {
        this.completionDate = completionDate;
    }

    public void setCompleted() {
        this.setCompletionDate(new Date());
        this.setStatus(TaskStatus.COMPLETED);
        this.addLogRecord(this.getCompletionDate());
    }

    public void SetExpired() {
        this.setStatus(TaskStatus.EXPIRED);
        this.addLogRecord(new Date());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Task)) {
            return false;
        }
        if (other == null) {
            return false;
        }
        Task that = (Task)other;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.type, (Object)that.type).append((Object)this.creationDate, (Object)that.creationDate).append((Object)this.expiryDate, (Object)that.expiryDate).append((Object)this.completionDate, (Object)that.completionDate).append((Object)this.status, (Object)that.status).append((Object)this.admin, (Object)that.admin).append((Object)this.user, (Object)that.user);
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(11, 67);
        builder.append((Object)this.getType()).append((Object)this.creationDate).append((Object)this.expiryDate).append((Object)this.completionDate).append((Object)this.status).append((Object)this.admin).append((Object)this.user);
        return builder.toHashCode();
    }

    public SortedSet<LogRecord> getLogRecords() {
        return this.logRecords;
    }

    public void setLogRecords(SortedSet<LogRecord> logRecords) {
        this.logRecords = logRecords;
    }

    public VOMSUser getUser() {
        return this.user;
    }

    public VOMSAdmin getAdmin() {
        return this.admin;
    }

    public void setUser(VOMSUser user) {
        this.user = user;
    }

    public void setAdmin(VOMSAdmin admin) {
        this.admin = admin;
    }

    protected void addLogRecord(Date d) {
        LogRecord r = new LogRecord();
        r.setDate(d);
        r.setEvent(this.getStatus());
        r.setTask(this);
        if (this.getUser() != null) {
            r.setUserDn(this.getUser().getDefaultCertificate().getSubjectString());
        }
        if (this.getAdmin() != null) {
            r.setAdminDn(this.getAdmin().getDn());
        }
        this.getLogRecords().add(r);
    }

    public long getDaysBeforeExpiration() {
        long now = new Date().getTime();
        return TimeUnit.MILLISECONDS.toDays(this.getExpiryDate().getTime() - now);
    }

    public static enum TaskStatus {
        CREATED,
        REASSIGNED,
        COMPLETED,
        EXPIRED;

    }
}

