/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.model.task;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.glite.security.voms.admin.persistence.model.AUP;
import org.glite.security.voms.admin.persistence.model.task.Task;
import org.glite.security.voms.admin.persistence.model.task.TaskType;

@Entity
@Table(name="sign_aup_task")
public class SignAUPTask
extends Task
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ManyToOne
    @JoinColumn(name="aup_id", nullable=false)
    AUP aup;

    public SignAUPTask() {
    }

    public SignAUPTask(TaskType tt, AUP a, Date expiryDate) {
        this.type = tt;
        this.aup = a;
        this.expiryDate = expiryDate;
        this.creationDate = new Date();
        this.status = Task.TaskStatus.CREATED;
        this.addLogRecord(this.getCreationDate());
    }

    public AUP getAup() {
        return this.aup;
    }

    public void setAup(AUP aup) {
        this.aup = aup;
    }

    public String toString() {
        return String.format("SignAUPTask[id:%d, status:%s, aup:%s, user:%s, expires:%s]", new Object[]{this.getId(), this.getStatus(), this.getAup(), this.getUser().toString(), this.getExpiryDate()});
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Task)) {
            return false;
        }
        if (other == null) {
            return false;
        }
        SignAUPTask that = (SignAUPTask)other;
        EqualsBuilder builder = new EqualsBuilder();
        return builder.appendSuper(super.equals(other)).append((Object)this.aup, (Object)that.aup).isEquals();
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(17, 57).appendSuper(super.hashCode()).append((Object)this.aup);
        return builder.toHashCode();
    }
}

