/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.glite.security.voms.User;
import org.glite.security.voms.admin.apiv2.VOMSUserJSON;
import org.glite.security.voms.admin.error.IllegalStateException;
import org.glite.security.voms.admin.error.NotFoundException;
import org.glite.security.voms.admin.error.NullArgumentException;
import org.glite.security.voms.admin.error.VOMSSyntaxException;
import org.glite.security.voms.admin.persistence.Auditable;
import org.glite.security.voms.admin.persistence.error.AlreadyExistsException;
import org.glite.security.voms.admin.persistence.error.NoSuchAttributeException;
import org.glite.security.voms.admin.persistence.error.NoSuchMappingException;
import org.glite.security.voms.admin.persistence.error.VOMSInconsistentDatabaseException;
import org.glite.security.voms.admin.persistence.model.AUP;
import org.glite.security.voms.admin.persistence.model.AUPAcceptanceRecord;
import org.glite.security.voms.admin.persistence.model.AUPVersion;
import org.glite.security.voms.admin.persistence.model.Certificate;
import org.glite.security.voms.admin.persistence.model.VOMSCA;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.VOMSMapping;
import org.glite.security.voms.admin.persistence.model.VOMSRole;
import org.glite.security.voms.admin.persistence.model.VOMSUserAttribute;
import org.glite.security.voms.admin.persistence.model.personal_info.PersonalInformationRecord;
import org.glite.security.voms.admin.persistence.model.request.RequesterInfo;
import org.glite.security.voms.admin.persistence.model.task.SignAUPTask;
import org.glite.security.voms.admin.persistence.model.task.Task;
import org.glite.security.voms.admin.util.PathNamingScheme;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Sort;
import org.hibernate.annotations.SortType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="usr")
public class VOMSUser
implements Serializable,
Auditable,
Comparable {
    private static final long serialVersionUID = -3815869585264835046L;
    public static final Logger log = LoggerFactory.getLogger(VOMSUser.class);
    @Id
    @Column(name="userid")
    @GeneratedValue(strategy=GenerationType.AUTO)
    Long id;
    String name;
    String surname;
    String institution;
    String address;
    @Column(name="phone_number")
    String phoneNumber;
    @Column(nullable=false, name="email_address")
    String emailAddress;
    String dn;
    @ManyToOne(targetEntity=VOMSCA.class, optional=true)
    @JoinColumn(name="ca")
    VOMSCA ca;
    @Column(name="creation_time", nullable=false)
    Date creationTime;
    @Column(name="end_time", nullable=false)
    Date endTime;
    @Column(name="suspended")
    Boolean suspended = false;
    @Enumerated(value=EnumType.STRING)
    @Column(name="suspension_reason_code")
    SuspensionReason suspensionReasonCode;
    @Column(name="suspension_reason")
    String suspensionReason;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="user")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    Set<VOMSUserAttribute> attributes = new HashSet<VOMSUserAttribute>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="user")
    @Sort(type=SortType.NATURAL)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    Set<VOMSMapping> mappings = new TreeSet<VOMSMapping>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="user")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    Set<Certificate> certificates = new HashSet<Certificate>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="user")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    Set<AUPAcceptanceRecord> aupAcceptanceRecords = new HashSet<AUPAcceptanceRecord>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="user", fetch=FetchType.EAGER)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    Set<Task> tasks = new HashSet<Task>();
    @Transient
    Set<PersonalInformationRecord> personalInformations = new HashSet<PersonalInformationRecord>();

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Set getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Set attributes) {
        this.attributes = attributes;
    }

    public Set getMappings() {
        return this.mappings;
    }

    public void setMappings(Set mappings) {
        this.mappings = mappings;
    }

    public VOMSUserAttribute getAttributeByName(String name) {
        for (VOMSUserAttribute tmp : this.attributes) {
            if (!tmp.getName().equals(name)) continue;
            return tmp;
        }
        return null;
    }

    public void deleteAttributeByName(String attrName) {
        this.deleteAttribute(this.getAttributeByName(attrName));
    }

    public void deleteAttribute(VOMSUserAttribute val) {
        if (!this.attributes.contains(val)) {
            throw new NoSuchAttributeException("Attribute \"" + val.getName() + "\" undefined for user " + this);
        }
        this.attributes.remove(val);
    }

    public void setAttribute(String name, String value) {
        VOMSUserAttribute val = this.getAttributeByName(name);
        if (val == null) {
            throw new NoSuchAttributeException("Attribute \"" + name + "\" undefined for user \"" + this + "\".");
        }
        val.setValue(value);
    }

    public void addAttribute(VOMSUserAttribute val) {
        val.setUser(this);
        if (this.attributes.contains(val)) {
            this.attributes.remove(val);
        }
        this.attributes.add(val);
    }

    public boolean isMember(String groupName) {
        if (groupName == null) {
            throw new NullArgumentException("Cannot org.glite.security.voms.admin.test membership in a null group!");
        }
        if (!PathNamingScheme.isGroup(groupName)) {
            throw new VOMSSyntaxException("Group name passed as argument does not respect the VOMS FQAN syntax. [" + groupName + "]");
        }
        for (VOMSMapping m : this.getMappings()) {
            if (!m.getGroup().getName().equals(groupName) || !m.isGroupMapping()) continue;
            return true;
        }
        return false;
    }

    public boolean isMember(VOMSGroup g) {
        if (g == null) {
            throw new NullArgumentException("Cannot org.glite.security.voms.admin.test membership in a null group!");
        }
        for (VOMSMapping m : this.getMappings()) {
            if (!m.getGroup().equals(g) || !m.isGroupMapping()) continue;
            return true;
        }
        return false;
    }

    public void addToGroup(VOMSGroup g) {
        log.debug("Adding user \"" + this + "\" to group \"" + g + "\".");
        VOMSMapping m = new VOMSMapping(this, g, null);
        if (!this.getMappings().add(m)) {
            throw new AlreadyExistsException("User \"" + this + "\" is already a member of group \"" + g + "\".");
        }
        if (!g.isRootGroup() && !this.isMember(g.parent)) {
            this.addToGroup(g.parent);
        }
    }

    public void removeFromGroup(VOMSGroup g) {
        log.debug("Removing user \"" + this + "\" from group \"" + g + "\".");
        this.dismissRolesInGroup(g);
        VOMSMapping m = new VOMSMapping(this, g, null);
        if (!this.getMappings().contains(m)) {
            throw new NoSuchMappingException("User \"" + this + "\" is not a member of group \"" + g + "\".");
        }
        this.getMappings().remove(m);
        g.getMappings().remove(m);
    }

    public VOMSMapping assignRole(VOMSGroup g, VOMSRole r) {
        if (!this.isMember(g)) {
            throw new NoSuchMappingException("User \"" + this + "\" is not a member of group \"" + g + "\".");
        }
        VOMSMapping m = new VOMSMapping(this, g, r);
        if (this.getMappings().contains(m)) {
            throw new AlreadyExistsException("User \"" + this + "\" already has role \"" + r + "\" in group \"" + g + "\".");
        }
        log.debug("Assigning role \"" + r + "\" to user \"" + this + "\" in group \"" + g + "\".");
        this.getMappings().add(m);
        r.getMappings().add(m);
        return m;
    }

    public VOMSMapping dismissRole(VOMSGroup g, VOMSRole r) {
        if (!this.isMember(g)) {
            throw new NoSuchMappingException("User \"" + this + "\" is not a member of group \"" + g + "\".");
        }
        if (!this.hasRole(g, r)) {
            throw new NoSuchMappingException("User \"" + this + "\" does not have role \"" + r + "\" in group \"" + g + "\".");
        }
        log.debug("Dismissing role \"" + r + "\" from user \"" + this + "\" in group \"" + g + "\".");
        Iterator i = this.getMappings().iterator();
        boolean removed = false;
        VOMSMapping m = null;
        while (i.hasNext()) {
            m = (VOMSMapping)i.next();
            if (!m.isRoleMapping() || !m.getGroup().equals(g) || !m.getRole().equals(r)) continue;
            i.remove();
            r.getMappings().remove(m);
            removed = true;
        }
        if (!removed) {
            throw new VOMSInconsistentDatabaseException("Error removing exiting role mapping!");
        }
        return m;
    }

    public void dismissRolesInGroup(VOMSGroup g) {
        if (!this.isMember(g)) {
            throw new NoSuchMappingException("User \"" + this + "\" is not a member of group \"" + g + "\".");
        }
        Iterator i = this.getMappings().iterator();
        while (i.hasNext()) {
            VOMSMapping m = (VOMSMapping)i.next();
            if (!m.getGroup().equals(g) || !m.isRoleMapping()) continue;
            i.remove();
        }
    }

    public boolean hasRole(VOMSGroup g, VOMSRole r) {
        if (!this.isMember(g)) {
            throw new NoSuchMappingException("User \"" + this + "\" is not a member of group \"" + g + "\".");
        }
        for (VOMSMapping m : this.getMappings()) {
            if (!m.isRoleMapping() || !m.getGroup().equals(g) || !m.getRole().equals(r)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRole(String fqan) {
        if (!PathNamingScheme.isQualifiedRole(fqan)) {
            throw new IllegalArgumentException("Role name passed as argument is not a qualified role! [" + fqan + "]");
        }
        String groupName = PathNamingScheme.getGroupName(fqan);
        String roleName = PathNamingScheme.getRoleName(fqan);
        for (VOMSMapping m : this.getMappings()) {
            if (!m.isRoleMapping() || !m.getGroup().getName().equals(groupName) || !m.getRole().getName().equals(roleName)) continue;
            return true;
        }
        return false;
    }

    public Set getGroups() {
        TreeSet<VOMSGroup> res = new TreeSet<VOMSGroup>();
        for (VOMSMapping m : this.getMappings()) {
            if (!m.isGroupMapping()) continue;
            res.add(m.getGroup());
        }
        return Collections.unmodifiableSortedSet(res);
    }

    public Set getRoles(VOMSGroup g) {
        TreeSet<VOMSRole> res = new TreeSet<VOMSRole>();
        for (VOMSMapping m : this.getMappings()) {
            if (!m.isRoleMapping() || !m.getGroup().equals(g)) continue;
            res.add(m.getRole());
        }
        return Collections.unmodifiableSortedSet(res);
    }

    public Set getRoleMappings() {
        TreeSet<String> res = new TreeSet<String>();
        for (VOMSMapping m : this.getMappings()) {
            if (!m.isRoleMapping()) continue;
            res.add(m.getFQAN());
        }
        return res;
    }

    public Map getMappingsMap() {
        log.debug("mappings.size(): " + this.getMappings().size());
        if (this.getMappings().size() == 0) {
            return null;
        }
        Iterator i = this.getMappings().iterator();
        TreeMap map = new TreeMap();
        while (i.hasNext()) {
            Set<VOMSRole> s;
            VOMSMapping m = (VOMSMapping)i.next();
            log.debug("mapping: " + m);
            if (m.isGroupMapping()) {
                log.debug("Added group mapping to map: " + m.getGroup());
                map.put(m.getGroup(), new TreeSet());
                continue;
            }
            if (!m.isRoleMapping()) continue;
            if (!map.containsKey(m.getGroup())) {
                s = new TreeSet<VOMSRole>();
                s.add(m.getRole());
                map.put(m.getGroup(), s);
                log.debug("Added mapping to map: " + m);
                continue;
            }
            s = (Set)map.get(m.getGroup());
            s.add(m.getRole());
            map.put(m.getGroup(), s);
            log.debug("Added mapping to map:" + m.getRole());
        }
        return map;
    }

    public void fromUser(User u) {
        if (u == null) {
            throw new NullArgumentException("User passed as argument is null!");
        }
        this.setEmailAddress(u.getMail());
    }

    public User asUser() {
        User u = new User();
        u.setDN(this.getDefaultCertificate().getSubjectString());
        u.setCA(this.getDefaultCertificate().getCa().getSubjectString());
        u.setCN(null);
        u.setMail(this.getEmailAddress());
        u.setCertUri(null);
        return u;
    }

    public static User[] collectionAsUsers(Collection c) {
        if (c == null || c.isEmpty()) {
            return null;
        }
        User[] users = new User[c.size()];
        int index = 0;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            users[index++] = ((VOMSUser)i.next()).asUser();
        }
        return users;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("id", (Object)this.id).append("defaultCertficate", (Object)this.getDefaultCertificate()).append("name", (Object)this.name).append("surname", (Object)this.surname).append("emailAddress", (Object)this.emailAddress).append("suspended", (Object)this.suspended).append("endTime", (Object)this.endTime);
        return builder.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof VOMSUser)) {
            return false;
        }
        VOMSUser that = (VOMSUser)other;
        if (this.getName() != null && this.getSurname() != null) {
            if (that.getName() != null && that.getSurname() != null) {
                if (this.getName().equals(that.getName()) && this.getSurname().equals(that.getSurname())) {
                    return this.getEmailAddress().equals(that.getEmailAddress());
                }
                return false;
            }
            this.getDefaultCertificate().equals(that.getDefaultCertificate());
        }
        if (this.getDefaultCertificate() == null) {
            if (this.getId() == null) {
                throw new IllegalStateException("No information available to compare two users: this=" + this + " , that=" + that);
            }
            return this.getId().equals(that.getId());
        }
        return this.getDefaultCertificate().equals(that.getDefaultCertificate());
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(11, 59);
        if (this.getName() != null && this.getSurname() != null) {
            builder.append((Object)this.name).append((Object)this.surname).append((Object)this.emailAddress);
        } else if (this.getDefaultCertificate() == null) {
            if (this.dn == null) {
                builder.append((Object)this.id);
            } else {
                builder.append((Object)this.dn);
            }
        } else {
            builder.append((Object)this.getDefaultCertificate().getSubjectString());
        }
        return builder.toHashCode();
    }

    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        if (o == null) {
            return 1;
        }
        VOMSUser that = (VOMSUser)o;
        if (this.getName() != null && this.getSurname() != null) {
            if (that.getName() != null && that.getSurname() != null) {
                if (this.getSurname().equals(that.getSurname())) {
                    return this.getName().compareTo(that.getName());
                }
                return this.getSurname().compareTo(that.getSurname());
            }
            return this.getDefaultCertificate().compareTo(that.getDefaultCertificate());
        }
        if (this.getDefaultCertificate() != null) {
            return this.getDefaultCertificate().compareTo(that.getDefaultCertificate());
        }
        return -1;
    }

    public String getShortName() {
        if (this.name == null) {
            if (this.getDefaultCertificate() == null) {
                return this.getDn();
            }
            return this.getDefaultCertificate().subjectString + "(" + this.getId() + ")";
        }
        return String.format("%s %s (%d)", this.name, this.surname, this.id);
    }

    public Set<Certificate> getCertificates() {
        return this.certificates;
    }

    public void setCertificates(Set<Certificate> certificates) {
        this.certificates = certificates;
    }

    public void addCertificate(Certificate cert) {
        if (this.hasCertificate(cert)) {
            throw new AlreadyExistsException("Certificate '" + cert + "' is already bound to user '" + this + "'.");
        }
        this.getCertificates().add(cert);
        cert.setUser(this);
    }

    public boolean hasCertificate(Certificate cert) {
        for (Certificate c : this.certificates) {
            if (!c.equals(cert)) continue;
            return true;
        }
        return false;
    }

    public List<Certificate> getCertificatesBySubject(String subject) {
        ArrayList<Certificate> result = new ArrayList<Certificate>();
        for (Certificate c : this.certificates) {
            if (!c.getSubjectString().equals(subject)) continue;
            result.add(c);
        }
        return result;
    }

    public void removeCertificate(Certificate cert) {
        if (!this.hasCertificate(cert)) {
            throw new NotFoundException("Certificate '" + cert + "' is not bound to user '" + this + "'.");
        }
        this.getCertificates().remove(cert);
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public long getDaysBeforeEndTime() {
        Date now = new Date();
        if (now.after(this.getEndTime())) {
            return -1L;
        }
        long timeDiff = this.getEndTime().getTime() - now.getTime();
        return TimeUnit.MILLISECONDS.toDays(timeDiff);
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getInstitution() {
        return this.institution;
    }

    public void setInstitution(String institution) {
        this.institution = institution;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public String getFullName() {
        return this.getName() + " " + this.getSurname();
    }

    public Certificate getDefaultCertificate() {
        Iterator<Certificate> iter = this.getCertificates().iterator();
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    public String getEscapedDn() {
        Certificate cert = this.getDefaultCertificate();
        if (cert == null) {
            return null;
        }
        return cert.getSubjectString().replaceAll("'", "\\\\'");
    }

    public Set<AUPAcceptanceRecord> getAupAcceptanceRecords() {
        return this.aupAcceptanceRecords;
    }

    public void setAupAcceptanceRecords(Set<AUPAcceptanceRecord> aupAcceptanceRecords) {
        this.aupAcceptanceRecords = aupAcceptanceRecords;
    }

    public boolean hasSignedAUP(AUPVersion aupVersion) {
        for (AUPAcceptanceRecord r : this.aupAcceptanceRecords) {
            if (!r.getAupVersion().equals(aupVersion)) continue;
            return true;
        }
        return false;
    }

    public AUPAcceptanceRecord getAUPAccceptanceRecord(AUPVersion aupVersion) {
        for (AUPAcceptanceRecord r : this.aupAcceptanceRecords) {
            if (!r.getAupVersion().equals(aupVersion)) continue;
            return r;
        }
        return null;
    }

    public Set<Task> getTasks() {
        return this.tasks;
    }

    public void setTasks(Set<Task> tasks) {
        this.tasks = tasks;
    }

    @Deprecated
    public String getDn() {
        if (this.getDefaultCertificate() != null) {
            return this.getDefaultCertificate().getSubjectString();
        }
        return this.dn;
    }

    @Deprecated
    public VOMSCA getCa() {
        if (this.getDefaultCertificate() != null) {
            return this.getDefaultCertificate().getCa();
        }
        return this.ca;
    }

    public Set<PersonalInformationRecord> getPersonalInformations() {
        return this.personalInformations;
    }

    public void setPersonalInformations(Set<PersonalInformationRecord> personalInformations) {
        this.personalInformations = personalInformations;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public void setCa(VOMSCA ca) {
        this.ca = ca;
    }

    public void assignTask(Task t) {
        if (!this.getTasks().contains(t)) {
            this.getTasks().add(t);
            t.setUser(this);
        }
    }

    public Task removeTask(Task t) {
        if (this.getTasks().contains(t)) {
            this.getTasks().remove(t);
            t.setUser(null);
            return t;
        }
        return null;
    }

    public boolean hasInvalidAUPAcceptanceRecordForAUP(AUP aup) {
        if (this.getAupAcceptanceRecords().isEmpty()) {
            return false;
        }
        for (AUPAcceptanceRecord r : this.getAupAcceptanceRecords()) {
            if (!r.getAupVersion().equals(aup.getActiveVersion()) || r.getValid().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean hasInvalidAUPAcceptanceRecord() {
        if (this.getAupAcceptanceRecords().isEmpty()) {
            return false;
        }
        for (AUPAcceptanceRecord r : this.getAupAcceptanceRecords()) {
            if (r.getValid().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean hasPendingSignAUPTasks() {
        if (this.getTasks().isEmpty()) {
            return false;
        }
        for (Task t : this.getTasks()) {
            SignAUPTask aupTask;
            if (!(t instanceof SignAUPTask) || (aupTask = (SignAUPTask)t).getStatus().equals((Object)Task.TaskStatus.COMPLETED)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPendingSignAUPTask(AUP aup) {
        if (this.getTasks().isEmpty()) {
            return false;
        }
        for (Task t : this.getTasks()) {
            if (!(t instanceof SignAUPTask)) continue;
            SignAUPTask aupTask = (SignAUPTask)t;
            log.debug("aupTask: " + aupTask);
            if (!aupTask.getAup().equals(aup) || aupTask.getStatus().equals((Object)Task.TaskStatus.COMPLETED)) continue;
            log.debug("Found pending aup task: " + aupTask);
            return true;
        }
        return false;
    }

    public SignAUPTask getPendingSignAUPTask(AUP aup) {
        if (this.getTasks().isEmpty()) {
            return null;
        }
        for (Task t : this.getTasks()) {
            SignAUPTask aupTask;
            if (!(t instanceof SignAUPTask) || !(aupTask = (SignAUPTask)t).getAup().equals(aup) || aupTask.getStatus().equals((Object)Task.TaskStatus.COMPLETED)) continue;
            return aupTask;
        }
        return null;
    }

    public void suspend(SuspensionReason reason) {
        this.setSuspended(true);
        this.setSuspensionReasonCode(reason);
        this.setSuspensionReason(reason.getMessage());
        for (Certificate c : this.getCertificates()) {
            if (c.isSuspended()) continue;
            c.suspend(reason);
        }
    }

    public void restore(SuspensionReason reason) {
        this.setSuspended(false);
        this.setSuspensionReason(null);
        for (Certificate c : this.getCertificates()) {
            c.restore(reason);
        }
    }

    public void restore() {
        this.setSuspended(false);
        this.setSuspensionReason(null);
        this.setSuspensionReasonCode(null);
        for (Certificate c : this.getCertificates()) {
            c.restore();
        }
    }

    public boolean isSuspended() {
        return this.suspended == null ? false : this.suspended;
    }

    public Boolean getSuspended() {
        return this.suspended;
    }

    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public SuspensionReason getSuspensionReasonCode() {
        return this.suspensionReasonCode;
    }

    public void setSuspensionReasonCode(SuspensionReason suspensionReasonCode) {
        this.suspensionReasonCode = suspensionReasonCode;
    }

    public String getSuspensionReason() {
        return this.suspensionReason;
    }

    public void setSuspensionReason(String suspensionReason) {
        this.suspensionReason = suspensionReason;
    }

    public boolean hasSuspendedCertificates() {
        for (Certificate c : this.certificates) {
            if (!c.isSuspended()) continue;
            return true;
        }
        return false;
    }

    public boolean hasExpired() {
        return this.endTime.before(new Date());
    }

    public long getDaysSinceExpiration() {
        if (this.hasExpired()) {
            Date now = new Date();
            long timediff = now.getTime() - this.getEndTime().getTime();
            return TimeUnit.MILLISECONDS.toDays(timediff);
        }
        return -1L;
    }

    public static VOMSUser fromVOMSUserJSON(VOMSUserJSON user) {
        VOMSUser u = new VOMSUser();
        u.setName(user.getName());
        u.setSurname(user.getSurname());
        u.setAddress(user.getAddress());
        u.setInstitution(user.getInstitution());
        u.setPhoneNumber(user.getPhoneNumber());
        u.setEmailAddress(user.getEmailAddress());
        return u;
    }

    public static VOMSUser fromRequesterInfo(RequesterInfo ri) {
        VOMSUser u = new VOMSUser();
        u.setDn(ri.getCertificateSubject());
        u.setName(ri.getName());
        u.setSurname(ri.getSurname());
        u.setAddress(ri.getAddress());
        u.setInstitution(ri.getInstitution());
        u.setPhoneNumber(ri.getPhoneNumber());
        u.setEmailAddress(ri.getEmailAddress());
        return u;
    }

    public static enum SuspensionReason {
        FAILED_TO_SIGN_AUP("User failed to sign the AUP in time."),
        MEMBERSHIP_EXPIRATION("User membership has expired."),
        SECURITY_INCIDENT("User membership has been suspended after a security incident."),
        OTHER("User membership has been suspended for another unknown reason.");

        String message;

        private SuspensionReason(String msg) {
            this.message = msg;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

