/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.glite.security.voms.admin.error.NullArgumentException;
import org.glite.security.voms.admin.error.VOMSSyntaxException;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.persistence.Auditable;
import org.glite.security.voms.admin.persistence.error.AlreadyExistsException;
import org.glite.security.voms.admin.persistence.model.Tag;
import org.glite.security.voms.admin.persistence.model.TagMapping;
import org.glite.security.voms.admin.persistence.model.VOMSCA;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.VOMSRole;
import org.glite.security.voms.admin.persistence.model.task.Task;
import org.glite.security.voms.admin.util.PathNamingScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VOMSAdmin
implements Serializable,
Auditable,
Cloneable {
    private static Logger log = LoggerFactory.getLogger(VOMSAdmin.class);
    private static final long serialVersionUID = -5459874418491929253L;
    Long id;
    String dn;
    VOMSCA ca;
    String emailAddress;
    Set<TagMapping> tagMappings = new HashSet<TagMapping>();
    Set<Task> tasks = new HashSet<Task>();

    public VOMSCA getCa() {
        return this.ca;
    }

    public void setCa(VOMSCA ca) {
        this.ca = ca;
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ca == null ? 0 : this.ca.hashCode());
        result = 31 * result + (this.dn == null ? 0 : this.dn.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VOMSAdmin other = (VOMSAdmin)obj;
        if (this.ca == null ? other.ca != null : !this.ca.equals(other.ca)) {
            return false;
        }
        return !(this.dn == null ? other.dn != null : !this.dn.equals(other.dn));
    }

    public Object clone() throws CloneNotSupportedException {
        VOMSAdmin newInstance = (VOMSAdmin)super.clone();
        newInstance.id = this.id;
        newInstance.dn = this.dn;
        newInstance.ca = this.ca;
        return newInstance;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        return builder.append((Object)this.dn).append((Object)this.ca.getSubjectString()).toString();
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public boolean isInternalAdmin() {
        return this.getCa().getSubjectString().startsWith("/O=VOMS/O=System");
    }

    public boolean isUnauthenticated() {
        return this.getDn().equals("/O=VOMS/O=System/CN=Unauthenticated Client") && this.getCa().getSubjectString().equals("/O=VOMS/O=System/CN=Dummy Certificate Authority");
    }

    public boolean isGroupAdmin() {
        boolean result;
        try {
            result = PathNamingScheme.isGroup(this.getDn());
        }
        catch (VOMSSyntaxException e) {
            return false;
        }
        return result;
    }

    public boolean isRoleAdmin() {
        boolean result;
        try {
            result = PathNamingScheme.isQualifiedRole(this.getDn());
        }
        catch (VOMSSyntaxException e) {
            return false;
        }
        return result;
    }

    public Set<TagMapping> getTagMappings() {
        return this.tagMappings;
    }

    public void setTagMappings(Set<TagMapping> mappings) {
        this.tagMappings = mappings;
    }

    public Set<Tag> getTagsInContext(VOMSContext c) {
        if (c.isGroupContext()) {
            return this.getTagsInGroup(c.getGroup());
        }
        return this.getTagsInRole(c.getGroup(), c.getRole());
    }

    public Set<Tag> getTagsInGroup(VOMSGroup g) {
        HashSet<Tag> result = new HashSet<Tag>();
        for (TagMapping m : this.tagMappings) {
            if (!m.getAdmin().equals(this) || !m.getGroup().equals(g)) continue;
            result.add(m.getTag());
        }
        return result;
    }

    public Set<Tag> getTagsInRole(VOMSGroup g, VOMSRole r) {
        HashSet<Tag> result = new HashSet<Tag>();
        for (TagMapping m : this.tagMappings) {
            if (!m.isGroupMapping() || !m.getAdmin().equals(this) || !m.getGroup().equals(g) || !m.getRole().equals(r)) continue;
            result.add(m.getTag());
        }
        return result;
    }

    public void assignTagInGroup(VOMSGroup group, Tag tag) {
        if (group == null) {
            throw new NullArgumentException("group cannot be null!");
        }
        if (tag == null) {
            throw new NullArgumentException("tag cannot be null!");
        }
        TagMapping m = new TagMapping(tag, group, null, this);
        if (!this.getTagMappings().add(m)) {
            throw new AlreadyExistsException("Admin '" + this + "' already has tag '" + tag + "' in group '" + group + "'");
        }
    }

    public void assignTagInRole(VOMSGroup group, VOMSRole role, Tag tag) {
        if (group == null) {
            throw new NullArgumentException("group cannot be null!");
        }
        if (tag == null) {
            throw new NullArgumentException("tag cannot be null!");
        }
        if (role == null) {
            throw new NullArgumentException("role cannot be null!");
        }
        TagMapping m = new TagMapping(tag, group, role, this);
        if (!this.getTagMappings().add(m)) {
            throw new AlreadyExistsException("Admin '" + this + "' already has tag '" + tag + "' in group '" + group + "'");
        }
    }

    public Set<Task> getTasks() {
        return this.tasks;
    }

    public void setTasks(Set<Task> tasks) {
        this.tasks = tasks;
    }
}

