/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.glite.security.voms.admin.persistence.model.VOMSCA;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.hibernate.annotations.NaturalId;

@Entity
@Table(name="certificate")
public class Certificate
implements Serializable,
Comparable<Certificate> {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="VOMS_CERT_SEQ")
    @SequenceGenerator(name="VOMS_CERT_SEQ", sequenceName="VOMS_CERT_SEQ")
    protected Long id;
    @Column(name="subject_string", nullable=false)
    @NaturalId
    protected String subjectString;
    @ManyToOne(targetEntity=VOMSCA.class, optional=false)
    @JoinColumn(name="ca_id", nullable=false)
    @NaturalId
    protected VOMSCA ca;
    @Transient
    protected String email;
    @Column(nullable=false)
    protected boolean suspended;
    @Enumerated(value=EnumType.STRING)
    @Column(name="suspension_reason_code")
    protected VOMSUser.SuspensionReason suspensionReasonCode;
    @Column(name="suspended_reason")
    protected String suspensionReason;
    @Column(nullable=false, name="creation_time")
    protected Date creationTime;
    @ManyToOne
    @JoinColumn(name="usr_id", nullable=false)
    protected VOMSUser user;

    public VOMSCA getCa() {
        return this.ca;
    }

    public void setCa(VOMSCA ca) {
        this.ca = ca;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSubjectString() {
        return this.subjectString;
    }

    public void setSubjectString(String subjectString) {
        this.subjectString = subjectString;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof Certificate)) {
            return false;
        }
        Certificate that = (Certificate)other;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getSubjectString(), (Object)that.getSubjectString()).append((Object)this.getCa(), (Object)that.getCa());
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(7, 37);
        builder.append((Object)this.getSubjectString()).append((Object)this.getCa());
        return builder.toHashCode();
    }

    public VOMSUser getUser() {
        return this.user;
    }

    public void setUser(VOMSUser user) {
        this.user = user;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("subject_string", (Object)this.subjectString).append("ca", (Object)this.ca);
        return builder.toString();
    }

    private List dnAsList(String dn) {
        String[] fields = dn.split("/");
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (String field : fields) {
            if (field.trim().length() == 0) continue;
            String[] val = field.split("=");
            result.add(val);
        }
        return result;
    }

    public List getSubjectAsList() {
        return this.dnAsList(this.getSubjectString());
    }

    public List getIssuerAsList() {
        return this.dnAsList(this.getCa().getSubjectString());
    }

    public String getSuspensionReason() {
        return this.suspensionReason;
    }

    public void setSuspensionReason(String suspensionReason) {
        this.suspensionReason = suspensionReason;
    }

    public VOMSUser.SuspensionReason getSuspensionReasonCode() {
        return this.suspensionReasonCode;
    }

    public void setSuspensionReasonCode(VOMSUser.SuspensionReason suspensionReasonCode) {
        this.suspensionReasonCode = suspensionReasonCode;
    }

    public void suspend(VOMSUser.SuspensionReason reason) {
        this.setSuspended(true);
        this.setSuspensionReasonCode(reason);
        this.setSuspensionReason(reason.getMessage());
    }

    public void restore() {
        if (this.isSuspended()) {
            this.setSuspended(false);
            this.setSuspensionReasonCode(null);
            this.setSuspensionReason(null);
        }
    }

    public void restore(VOMSUser.SuspensionReason reason) {
        if (this.isSuspended() && this.getSuspensionReasonCode().equals((Object)reason)) {
            this.setSuspended(false);
            this.setSuspensionReasonCode(null);
            this.setSuspensionReason(null);
        }
    }

    @Override
    public int compareTo(Certificate o) {
        CompareToBuilder builder = new CompareToBuilder();
        builder.append((Object)this.subjectString, (Object)o.subjectString).append((Object)this.ca.getSubjectString(), (Object)o.ca.getSubjectString());
        return builder.toComparison();
    }
}

