/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.persistence.dao.VOMSAdminDAO;
import org.glite.security.voms.admin.persistence.model.VOMSAdmin;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.VOMSRole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACL
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ACL.class);
    Long id;
    VOMSGroup group = null;
    Boolean defaultACL;
    VOMSRole role = null;
    Map<VOMSAdmin, VOMSPermission> permissions = new HashMap<VOMSAdmin, VOMSPermission>();

    public ACL() {
    }

    public ACL(VOMSGroup g, VOMSRole r, boolean isDefaultACL) {
        this.group = g;
        this.role = r;
        this.defaultACL = new Boolean(isDefaultACL);
    }

    public ACL(VOMSGroup g, boolean isDefaultACL) {
        this(g, null, isDefaultACL);
    }

    public VOMSGroup getGroup() {
        return this.group;
    }

    public void setGroup(VOMSGroup group) {
        this.group = group;
    }

    public Map<VOMSAdmin, VOMSPermission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Map<VOMSAdmin, VOMSPermission> permissions) {
        this.permissions = permissions;
    }

    public VOMSRole getRole() {
        return this.role;
    }

    public void setRole(VOMSRole role) {
        this.role = role;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ACL)) {
            return false;
        }
        ACL that = (ACL)other;
        if (that == null) {
            return false;
        }
        if (this.getGroup().equals(that.getGroup())) {
            if (this.getRole() == null && that.getRole() == null) {
                return this.getDefaultACL().equals(that.getDefaultACL());
            }
            if (this.getRole() != null && that.getRole() != null) {
                return this.getRole().equals(that.getRole());
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 14;
        result = 29 * result + this.getGroup().hashCode();
        if (this.getRole() != null) {
            result = 29 * result + this.getRole().hashCode();
        }
        return result;
    }

    public Boolean getDefaultACL() {
        return this.defaultACL;
    }

    public void setDefaultACL(Boolean defaultACL) {
        this.defaultACL = defaultACL;
    }

    public Long getId() {
        return this.id;
    }

    public void setPermissions(VOMSAdmin a, VOMSPermission p) {
        this.getPermissions().put(a, p);
    }

    public void removePermissions(VOMSAdmin a) {
        this.getPermissions().remove(a);
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean isDefautlACL() {
        return this.defaultACL;
    }

    public VOMSPermission getPermissions(VOMSAdmin a) {
        return this.getPermissions().get(a);
    }

    public Map<VOMSAdmin, VOMSPermission> getRolePermissions() {
        HashMap<VOMSAdmin, VOMSPermission> result = new HashMap<VOMSAdmin, VOMSPermission>();
        for (Map.Entry<VOMSAdmin, VOMSPermission> entry : this.getPermissions().entrySet()) {
            VOMSAdmin admin = entry.getKey();
            if (!admin.getCa().getSubjectString().equals("/O=VOMS/O=System/CN=VOMS Role")) continue;
            result.put(admin, entry.getValue());
        }
        return result;
    }

    public Map<VOMSAdmin, VOMSPermission> getGroupPermissions() {
        HashMap<VOMSAdmin, VOMSPermission> result = new HashMap<VOMSAdmin, VOMSPermission>();
        for (Map.Entry<VOMSAdmin, VOMSPermission> entry : this.getPermissions().entrySet()) {
            VOMSAdmin admin = entry.getKey();
            if (!admin.getCa().getSubjectString().equals("/O=VOMS/O=System/CN=VOMS Group")) continue;
            result.put(admin, entry.getValue());
        }
        return result;
    }

    public Set<VOMSAdmin> getAdminsWithPermissions(VOMSPermission requiredPermission) {
        HashSet<VOMSAdmin> results = new HashSet<VOMSAdmin>();
        for (Map.Entry<VOMSAdmin, VOMSPermission> entry : this.getPermissions().entrySet()) {
            VOMSAdmin a = entry.getKey();
            VOMSPermission p = entry.getValue();
            if (!p.satisfies(requiredPermission)) continue;
            results.add(a);
        }
        return results;
    }

    public VOMSPermission getAnyAuthenticatedUserPermissions() {
        VOMSAdmin anyAuthenticatedUserAdmin = VOMSAdminDAO.instance().getAnyAuthenticatedUserAdmin();
        return this.permissions.get(anyAuthenticatedUserAdmin);
    }

    public VOMSPermission getUnauthenticatedClientPermissions() {
        VOMSAdmin unauthenticatedClient = VOMSAdminDAO.instance().getUnauthenticatedClientAdmin();
        if (unauthenticatedClient == null) {
            return null;
        }
        return this.permissions.get(unauthenticatedClient);
    }

    public Map<VOMSAdmin, VOMSPermission> getExternalPermissions() {
        HashMap<VOMSAdmin, VOMSPermission> result = new HashMap<VOMSAdmin, VOMSPermission>();
        for (VOMSAdmin admin : this.permissions.keySet()) {
            if (!admin.getDn().equals("/O=VOMS/O=System/CN=Any Authenticated User") && !admin.getDn().equals("/O=VOMS/O=System/CN=Unauthenticated Client") && admin.getDn().startsWith("/O=VOMS/O=System")) continue;
            result.put(admin, this.permissions.get(admin));
        }
        return result;
    }

    public VOMSContext getContext() {
        return VOMSContext.instance(this.getGroup(), this.getRole());
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("id", (Object)this.id).append("defaultACL", (Object)this.defaultACL).append("group", (Object)this.group).append("role", (Object)this.role).append("permissions", this.permissions);
        return builder.toString();
    }
}

