/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.deployer;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.configuration.ConfigurationException;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.core.tasks.DatabaseSetupTask;
import org.glite.security.voms.admin.core.tasks.UpdateCATask;
import org.glite.security.voms.admin.error.VOMSException;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.persistence.DBUtil;
import org.glite.security.voms.admin.persistence.HibernateFactory;
import org.glite.security.voms.admin.persistence.dao.ACLDAO;
import org.glite.security.voms.admin.persistence.dao.CertificateDAO;
import org.glite.security.voms.admin.persistence.dao.VOMSAdminDAO;
import org.glite.security.voms.admin.persistence.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.persistence.dao.VOMSRoleDAO;
import org.glite.security.voms.admin.persistence.dao.VOMSUserDAO;
import org.glite.security.voms.admin.persistence.dao.VOMSVersionDAO;
import org.glite.security.voms.admin.persistence.dao.generic.DAOFactory;
import org.glite.security.voms.admin.persistence.deployer.ACLMapper;
import org.glite.security.voms.admin.persistence.error.VOMSDatabaseException;
import org.glite.security.voms.admin.persistence.model.ACL;
import org.glite.security.voms.admin.persistence.model.AUP;
import org.glite.security.voms.admin.persistence.model.Certificate;
import org.glite.security.voms.admin.persistence.model.VOMSAdmin;
import org.glite.security.voms.admin.persistence.model.VOMSCA;
import org.glite.security.voms.admin.persistence.model.VOMSDBVersion;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.VOMSRole;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.glite.security.voms.admin.util.SysconfigUtil;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;
import org.hibernate.dialect.Dialect;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.type.LongType;
import org.hibernate.type.ShortType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaDeployer {
    public static final String ORACLE_PRODUCT_NAME = "Oracle";
    public static final String MYSQL_PRODUCT_NAME = "MySQL";
    private static final Logger log = LoggerFactory.getLogger(SchemaDeployer.class);
    protected CommandLineParser parser = new PosixParser();
    protected HelpFormatter helpFormatter = new HelpFormatter();
    protected Options options;
    String command;
    String vo;
    String hibernateConfigFile = null;
    String hibernatePropertiesFile = null;
    String adminDN = null;
    String adminCA = null;
    String adminEmailAddress = null;
    SessionFactory sf;
    protected Dialect dialect;

    public SchemaDeployer(String[] args) {
        this.setupCLParser();
        this.checkArguments(args);
        this.execute();
    }

    private void printUpgradeScript() {
        SchemaUpdate updater = new SchemaUpdate(this.loadHibernateConfiguration());
        updater.execute(true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDatabaseConnectivity() {
        log.info("Checking database connectivity...");
        Session s = null;
        try {
            s = HibernateFactory.getFactory().openSession();
            s.beginTransaction();
        }
        catch (GenericJDBCException e) {
            log.error("");
            log.error("===========================================================================================================================");
            log.error("Error connecting to the voms database! Check your database settings and ensure that the database backend is up and running.");
            log.error("============================================================================================================================");
            if (log.isDebugEnabled()) {
                log.error(e.getMessage(), (Throwable)e);
            }
            System.exit(-1);
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
        log.info("Database contacted succesfully");
    }

    private void checkDatabaseWritable() {
        log.info("Checking that the database is writable...");
        Session s = null;
        try {
            s = HibernateFactory.getFactory().openSession();
            Transaction t = s.beginTransaction();
            s.createSQLQuery("create table writetest(integer a)");
            t.commit();
            t = s.beginTransaction();
            s.createSQLQuery("drop table writetest");
            t.commit();
        }
        catch (Throwable t) {
            log.error("Error writing to the voms database. Check your database settings and that the database backend is up and running.");
            if (log.isDebugEnabled()) {
                log.error("Error opening connection to the voms database. Check your database settings, or ensure that the local is up & running\nCause:" + t.getMessage(), t);
            }
            throw new VOMSDatabaseException("Error opening connection to the voms database. Check your database settings, or ensure that the local is up & running", t);
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
        log.info("Database is writable.");
    }

    private void execute() {
        System.setProperty("voms.vo.name", this.vo);
        VOMSConfiguration.load(null);
        if (this.command.equals("deploy")) {
            this.doDeploy();
        } else if (this.command.equals("undeploy")) {
            this.doUndeploy();
        } else if (this.command.equals("upgrade")) {
            this.doUpgrade();
        } else if (this.command.equals("add-admin")) {
            this.doAddAdmin();
        } else if (this.command.equals("remove-admin")) {
            this.doRemoveAdmin();
        } else if (this.command.equals("upgrade-script")) {
            this.printUpgradeScript();
        } else if (this.command.equals("check-connectivity")) {
            this.checkDatabaseExistence();
        } else if (this.command.equals("grant-read-only-access")) {
            this.doGrantROAccess();
        } else {
            System.err.println("Unkown command specified: " + this.command);
            System.exit(2);
        }
    }

    private boolean isOracleBackend() {
        org.hibernate.Session s = HibernateFactory.getSession();
        s.beginTransaction();
        DatabaseMetaData dbMetadata = null;
        String dbProductName = null;
        try {
            dbMetadata = s.connection().getMetaData();
            dbProductName = dbMetadata.getDatabaseProductName();
        }
        catch (HibernateException e) {
            log.error("Hibernate error accessing database metadata from Hibernate connection!", (Throwable)e);
            System.exit(-1);
        }
        catch (SQLException e) {
            log.error("SQL error while accessing database metadata from Hibernate connection!", (Throwable)e);
            System.exit(-1);
        }
        log.debug("Detected database: " + dbProductName);
        return dbProductName.trim().equals(ORACLE_PRODUCT_NAME);
    }

    private void printException(Throwable t) {
        if (t.getMessage() != null) {
            log.error(t.getMessage());
        } else {
            log.error(t.toString());
        }
        if (log.isDebugEnabled()) {
            if (t.getMessage() != null) {
                log.error(t.getMessage(), t);
            } else {
                log.error(t.toString(), t);
            }
        }
    }

    private void printAllException(Throwable t) {
        if (t != null) {
            this.printException(t);
        }
        if (t.getCause() != null) {
            log.error("caused by:");
            this.printAllException(t.getCause());
        }
    }

    private void printExceptions(List l) {
        for (Throwable t : l) {
            log.error(t.getMessage());
            if (!log.isDebugEnabled()) continue;
            this.printAllException(t);
        }
    }

    private String getVarcharType() {
        if (this.isOracleBackend()) {
            return "varchar2";
        }
        return "varchar";
    }

    private String getTimestampType() {
        if (this.isOracleBackend()) {
            return "timestamp";
        }
        return "datetime";
    }

    private ResultSet getTableNamesMatchingPattern(DatabaseMetaData md, String pattern) {
        String[] names = new String[]{"TABLE"};
        ResultSet tableNames = null;
        try {
            tableNames = md.getTables(null, "%", pattern, names);
        }
        catch (SQLException e) {
            log.error("Error reading table names from database metadata object!", (Throwable)e);
            System.exit(-1);
        }
        return tableNames;
    }

    private int checkDatabaseExistence() {
        this.checkVoExistence();
        this.checkDatabaseConnectivity();
        log.info("Checking database existence...");
        org.hibernate.Session s = HibernateFactory.getSession();
        DatabaseMetaData dbMetadata = null;
        try {
            dbMetadata = s.connection().getMetaData();
        }
        catch (HibernateException e) {
            log.error("Hibernate error accessing database metadata from Hibernate connection!", (Throwable)e);
            System.exit(-1);
        }
        catch (SQLException e) {
            log.error("SQL error while accessing database metadata from Hibernate connection!", (Throwable)e);
            System.exit(-1);
        }
        ResultSet tableNames = this.getTableNamesMatchingPattern(dbMetadata, "%");
        boolean foundACL2 = false;
        boolean foundACL = false;
        boolean foundAUP = false;
        try {
            while (tableNames.next()) {
                String tName = tableNames.getString("TABLE_NAME");
                if (tName.equals("ACL") || tName.equals("acl")) {
                    foundACL = true;
                }
                if (tName.equals("ACL2") || tName.equals("acl2")) {
                    foundACL2 = true;
                }
                if (!tName.equalsIgnoreCase("aup")) continue;
                foundAUP = true;
            }
            HibernateFactory.commitTransaction();
        }
        catch (SQLException e) {
            log.error("Error accessing table names result set!", (Throwable)e);
            System.exit(-1);
        }
        catch (HibernateException e) {
            log.error("Error committing read-only hibernate transaction!", (Throwable)e);
            System.exit(-1);
        }
        if (foundACL2 && foundAUP) {
            log.info("Found existing voms-admin > 2.5.x database...");
            return 3;
        }
        if (foundACL2) {
            log.info("Found existing voms-admin 2.0.x database...");
            return 2;
        }
        if (foundACL) {
            log.info("Found existing voms-admin 1.2.x database...");
            return 1;
        }
        log.info("No voms-admin database found.");
        return -1;
    }

    private void doUpgrade1_2_19(Configuration hibernateConfig) {
        HibernateFactory.beginTransaction();
        try {
            this.renameTables_1_2_19();
            HibernateFactory.commitTransaction();
            HibernateFactory.beginTransaction();
            SchemaExport exporter = new SchemaExport(hibernateConfig);
            exporter.execute(true, true, false, true);
            log.info("Deploying voms 2 database...");
            List l = exporter.getExceptions();
            if (!l.isEmpty()) {
                log.error("Error deploying voms 2 database!");
                this.printExceptions(l);
                System.exit(2);
            }
            if (this.isOracleBackend()) {
                this.fixHibernateSequence();
            }
            this.removeDuplicatedACLEntries();
            this.migrateDbContents();
            this.migrateMappings();
            this.migrateACLs();
            this.dropOldTables_1_2_19();
            if (this.isOracleBackend()) {
                this.dropOldSequences();
            }
            HibernateFactory.commitTransaction();
            log.info("Database upgraded succesfully!");
        }
        catch (Throwable t) {
            log.error("Database upgrade failed!");
            HibernateFactory.rollbackTransaction();
            HibernateFactory.closeSession();
            System.exit(2);
        }
    }

    private void implicitAUPSignup() {
        log.info("Adding implicit AUP sign records for vo users");
        List users = VOMSUserDAO.instance().findAll();
        AUP aup = DAOFactory.instance().getAUPDAO().getVOAUP();
        for (VOMSUser u : users) {
            VOMSUserDAO.instance().signAUP(u, aup);
        }
    }

    private List<String> loadUpgradeScript() throws IOException {
        String line;
        String upgradeScriptFileName = "/upgrade-scripts/mysql-upgrade_20_25.sql";
        if (this.isOracleBackend()) {
            upgradeScriptFileName = "/upgrade-scripts/oracle-upgrade_20_25.sql";
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(upgradeScriptFileName)));
        ArrayList<String> commands = new ArrayList<String>();
        do {
            if ((line = reader.readLine()) == null) continue;
            commands.add(line);
        } while (line != null);
        return commands;
    }

    private void fixHibernateSequences261(Configuration hibernateConfig) {
        String[] newOracleSequences = new String[]{"VOMS_ACL_SEQ", "VOMS_ADMIN_SEQ", "VOMS_ATTR_DESC_SEQ", "VOMS_AUP_ACC_REC_SEQ", "VOMS_AUP_SEQ", "VOMS_AUP_VER_SEQ", "VOMS_CA_SEQ", "VOMS_CERT_SEQ", "VOMS_GROUP_SEQ", "VOMS_M_SEQ", "VOMS_PI_SEQ", "VOMS_PI_TYPE_SEQ", "VOMS_REQ_INFO_SEQ", "VOMS_REQ_SEQ", "VOMS_ROLE_SEQ", "VOMS_TAG_MAP_SEQ", "VOMS_TAG_SEQ", "VOMS_TASK_LR_SEQ", "VOMS_TASK_SEQ", "VOMS_TASK_TYPE_SEQ"};
        log.info("Creating oracle sequences starting from VOMS Admin 2.6.x database.");
        org.hibernate.Session s = HibernateFactory.getSession();
        Long maxSeqValue = (Long)s.createSQLQuery("select max(last_number) as max from user_sequences where sequence_name = 'HIBERNATE_SEQUENCE'").addScalar("max", (Type)new LongType()).uniqueResult();
        for (String seq : newOracleSequences) {
            String createHibSeqStatement = "create sequence " + seq + " MINVALUE 1 MAXVALUE 999999999999999999999999999 " + "INCREMENT BY 1 START WITH " + maxSeqValue + " CACHE 20 NOORDER NOCYCLE";
            s.createSQLQuery(createHibSeqStatement).executeUpdate();
        }
        log.info("Sequences migration complete.");
    }

    private void doUpgrade2_5(Configuration hibernateConfig) {
        HibernateFactory.beginTransaction();
        VOMSDBVersion version = VOMSVersionDAO.instance().getVersion();
        if (this.isOracleBackend() && (version.getAdminVersion().equals("2.6.1") || version.getAdminVersion().equals("2.5.5"))) {
            try {
                this.fixHibernateSequences261(hibernateConfig);
            }
            catch (Exception e) {
                log.error("Error fixing VOMS Admin 2.6.1 oracle sequence: {}", (Object)e.getMessage(), (Object)e);
                HibernateFactory.rollbackTransaction();
            }
        }
        HibernateFactory.commitTransaction();
    }

    private void doUpgrade2_0_x(Configuration hibernateConfig) {
        try {
            HibernateFactory.beginTransaction();
            List<String> upgradeScript = this.loadUpgradeScript();
            ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
            log.info("Upgrading voms database...");
            Statement statement = HibernateFactory.getSession().connection().createStatement();
            for (String command : upgradeScript) {
                try {
                    log.info(command);
                    statement.executeUpdate(command);
                }
                catch (SQLException e) {
                    log.error("Error while executing: " + command);
                    exceptions.add(e);
                }
            }
            if (!exceptions.isEmpty()) {
                log.error("Error upgrading voms database!");
                this.printExceptions(exceptions);
                System.exit(2);
            }
            this.dropUnusedTables_2_0_x();
            this.fixCaTable();
            this.migrateUsrTable();
            HibernateFactory.commitTransaction();
            HibernateFactory.beginTransaction();
            this.fixUsrTable();
            this.updateACLPerms();
            DatabaseSetupTask.instance().run();
            this.dropOrphanedAdministrators();
            this.implicitAUPSignup();
            log.info("Upgrading database version information");
            VOMSVersionDAO.instance().setupVersion();
            HibernateFactory.commitTransaction();
            log.info("Database upgrade successfull!");
        }
        catch (Throwable t) {
            log.error("Database upgrade failed!", t);
            HibernateFactory.rollbackTransaction();
            HibernateFactory.closeSession();
            System.exit(2);
        }
        System.exit(0);
    }

    private void doUpgrade() {
        this.checkVoExistence();
        Configuration hibernateConfig = this.loadHibernateConfiguration();
        int existingDB = this.checkDatabaseExistence();
        if (existingDB == -1) {
            log.error("No voms-admin 1.2.x database found to upgrade!");
            System.exit(-1);
        }
        if (existingDB == 1) {
            log.info("Upgrading voms-admin 1.2.x database to the voms-admin > 2.5.x structure.");
            this.doUpgrade1_2_19(hibernateConfig);
        }
        if (existingDB == 2) {
            log.info("Upgrading voms-admin 2.0.x database to the voms-admin > 2.5.x structure.");
            this.doUpgrade2_0_x(hibernateConfig);
        }
        if (existingDB == 3) {
            log.info("Upgrading voms-admin 2.5.x database to the latest schema.");
            this.doUpgrade2_5(hibernateConfig);
        }
    }

    private void doRemoveAdmin() {
        this.checkVoExistence();
        if (this.adminDN == null || this.adminCA == null) {
            throw new VOMSException("adminDN or adminCA is not set!");
        }
        try {
            VOMSAdmin a = VOMSAdminDAO.instance().getByName(this.adminDN, this.adminCA);
            if (a == null) {
                log.info("Admin '" + this.adminDN + "," + this.adminCA + "' does not exists in database...");
                return;
            }
            ACLDAO.instance().deletePermissionsForAdmin(a);
            VOMSAdminDAO.instance().delete(a);
            HibernateFactory.commitTransaction();
            log.info("Administrator '{},{}' removed", (Object[])new String[]{a.getDn(), a.getCa().getSubjectString()});
        }
        catch (Throwable t) {
            log.error("Error removing administrator!");
            log.error(t.toString(), t);
            System.exit(-1);
        }
    }

    private void doAddAdmin() {
        this.checkVoExistence();
        if (this.adminDN == null || this.adminCA == null) {
            throw new VOMSException("adminDN or adminCA not set!");
        }
        HibernateFactory.beginTransaction();
        try {
            VOMSAdmin a = VOMSAdminDAO.instance().getByName(this.adminDN, this.adminCA);
            if (a != null) {
                log.info("Admin '" + a.getDn() + "," + a.getCa().getDn() + "' already exists in database...");
                log.warn("This admin will be granted full privileges on the VOMS database.");
            } else {
                log.info("Admin '" + this.adminDN + "," + this.adminCA + "' not found. It will be created...");
                a = VOMSAdminDAO.instance().create(this.adminDN, this.adminCA, this.adminEmailAddress);
            }
            for (VOMSGroup g : VOMSGroupDAO.instance().findAll()) {
                g.getACL().setPermissions(a, VOMSPermission.getAllPermissions());
                log.info("Adding ALL permissions on '{}' for admin '{},{}'", (Object[])new String[]{g.toString(), a.getDn(), a.getCa().getSubjectString()});
                for (VOMSRole r : VOMSRoleDAO.instance().findAll()) {
                    r.getACL(g).setPermissions(a, VOMSPermission.getAllPermissions());
                    log.info("Adding ALL permissions on role '{}/{}' for admin '{},{}'", (Object[])new String[]{g.toString(), r.toString(), a.getDn(), a.getCa().getSubjectString()});
                    HibernateFactory.getSession().save((Object)r);
                }
                HibernateFactory.getSession().save((Object)g);
            }
            HibernateFactory.commitTransaction();
        }
        catch (Throwable t) {
            log.error("Error adding new administrator!");
            log.error(t.toString(), t);
            System.exit(-1);
        }
    }

    private String getVOConfigurationDir() {
        Properties sysconfProps = SysconfigUtil.loadSysconfig();
        String confDir = sysconfProps.getProperty("CONF_DIR");
        if (confDir == null) {
            confDir = "/etc/voms-admin";
        }
        return confDir;
    }

    private boolean isVoConfigured(String voName) {
        String confDir = this.getVOConfigurationDir();
        File voConfDir = new File(confDir + "/" + voName);
        return voConfDir.exists() && voConfDir.isDirectory();
    }

    private Configuration loadHibernateConfiguration() {
        Configuration cfg = this.hibernatePropertiesFile == null ? DBUtil.loadHibernateConfiguration(this.getVOConfigurationDir(), this.vo) : DBUtil.loadHibernateConfiguration(this.hibernatePropertiesFile);
        this.dialect = Dialect.getDialect((Properties)cfg.getProperties());
        return cfg;
    }

    private void doUndeploy() {
        this.checkVoExistence();
        log.info("Undeploying voms database...");
        Configuration hibernateConfig = this.loadHibernateConfiguration();
        int existingDB = this.checkDatabaseExistence();
        if (existingDB == 1) {
            log.error("This tool cannot undeploy voms-admin 1.2.x database! Please upgrade to voms-admin 2 or use voms-admin-configure 1.2.x tools to undeploy this database.");
            System.exit(-1);
        }
        if (existingDB == 2) {
            log.error("This tool cannot undeploy voms-admin 2.0.x databases! Please either upgrade the database to voms-admin 2.5 (using this tool) or use voms-admin-configure 2.0.x tools to undeploy this database");
            System.exit(-1);
        }
        if (existingDB < 0) {
            log.error("No voms-admin database found!");
            System.exit(-1);
        }
        this.checkDatabaseWritable();
        SchemaExport export = new SchemaExport(hibernateConfig);
        export.drop(false, true);
        List l = export.getExceptions();
        if (!l.isEmpty()) {
            log.error("Error undeploying voms database!");
            this.printExceptions(l);
            System.exit(2);
        }
        log.info("Database undeployed correctly!");
    }

    private void checkVoExistence() {
        if (!this.isVoConfigured(this.vo)) {
            log.error("VO {} is not configured on this host.", (Object)this.vo);
            System.exit(1);
        }
    }

    private void doGrantROAccess() {
        try {
            this.checkVoExistence();
            this.checkDatabaseWritable();
            HibernateFactory.beginTransaction();
            VOMSAdmin anyUserAdmin = VOMSAdminDAO.instance().getAnyAuthenticatedUserAdmin();
            VOMSPermission readOnlyPerms = VOMSPermission.getEmptyPermissions().setContainerReadPermission().setMembershipReadPermission();
            List groups = VOMSGroupDAO.instance().findAll();
            for (VOMSGroup g : groups) {
                g.getACL().setPermissions(anyUserAdmin, readOnlyPerms);
                log.info("Granting read-only access to any authenticated user on group '{}'", (Object)g.getName());
                List roles = VOMSRoleDAO.instance().findAll();
                for (VOMSRole r : roles) {
                    r.getACL(g).setPermissions(anyUserAdmin, readOnlyPerms);
                    log.info("Granting read-only access to any authenticated user on role '{}/{}'", (Object[])new String[]{g.toString(), r.toString()});
                    HibernateFactory.getSession().save((Object)r);
                }
                HibernateFactory.getSession().save((Object)g);
            }
            HibernateFactory.commitTransaction();
        }
        catch (Throwable t) {
            log.error("Error creating read-only access grants!");
            log.error(t.toString(), t);
            System.exit(-1);
        }
    }

    private void doDeploy() {
        this.checkVoExistence();
        Configuration hibernateConfig = this.loadHibernateConfiguration();
        int existingDb = this.checkDatabaseExistence();
        if (existingDb > 0) {
            log.warn("Existing voms database found. Will not overwrite the database!");
            System.exit(0);
        }
        this.checkDatabaseWritable();
        SchemaExport exporter = new SchemaExport(hibernateConfig);
        exporter.execute(true, true, false, true);
        log.info("Deploying voms database...");
        List l = exporter.getExceptions();
        if (!l.isEmpty()) {
            log.error("Error deploying voms database!");
            this.printExceptions(l);
            System.exit(2);
        }
        UpdateCATask caTask = new UpdateCATask();
        caTask.run();
        DatabaseSetupTask task = DatabaseSetupTask.instance();
        task.run();
        HibernateFactory.commitTransaction();
        log.info("Database deployed correctly!");
    }

    protected void setupCLParser() {
        this.options = new Options();
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"Displays helps and exits.");
        this.options.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.withLongOpt((String)"command");
        OptionBuilder.withDescription((String)"Specifies the command to be executed: deploy,undeploy,upgrade,add-admin");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"command"));
        OptionBuilder.withLongOpt((String)"vo");
        OptionBuilder.withDescription((String)"Specifies the vo name.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"vo"));
        OptionBuilder.withLongOpt((String)"config");
        OptionBuilder.withDescription((String)"Specifies the hibernate config file to be used.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"config"));
        OptionBuilder.withLongOpt((String)"properties");
        OptionBuilder.withDescription((String)"Specifies the hibernate properties file to be used.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"properties"));
        OptionBuilder.withLongOpt((String)"dn");
        OptionBuilder.withDescription((String)"Specifies the dn for the admin to add (valid only if add-admin command is given).");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"dn"));
        OptionBuilder.withLongOpt((String)"ca");
        OptionBuilder.withDescription((String)"Specifies the ca for the admin to add (valid only if add-admin command is given).");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"ca"));
        OptionBuilder.withLongOpt((String)"email");
        OptionBuilder.withDescription((String)"Specifies the email address for the admin to add (valid only if add-admin command is given).");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"email"));
    }

    protected void checkArguments(String[] args) {
        try {
            CommandLine line = this.parser.parse(this.options, args);
            if (line.hasOption("h")) {
                this.printHelpMessageAndExit(0);
            }
            if (!line.hasOption("command")) {
                System.err.println("No command specified!");
                this.printHelpMessageAndExit(1);
            }
            if (!line.hasOption("vo")) {
                System.err.println("No vo specified!");
                this.printHelpMessageAndExit(1);
            }
            this.command = line.getOptionValue("command");
            if (!(this.command.equals("deploy") || this.command.equals("upgrade") || this.command.equals("add-admin") || this.command.equals("remove-admin") || this.command.equals("undeploy") || this.command.equals("upgrade-script") || this.command.equals("check-connectivity") || this.command.equals("grant-read-only-access"))) {
                System.err.println("Unknown command specified: " + this.command);
                this.printHelpMessageAndExit(2);
            }
            this.vo = line.getOptionValue("vo");
            if (line.hasOption("hb-config")) {
                this.hibernateConfigFile = line.getOptionValue("hb-config");
            }
            if (line.hasOption("hb-properties")) {
                this.hibernatePropertiesFile = line.getOptionValue("hb-properties");
            }
            if (line.hasOption("dn")) {
                this.adminDN = line.getOptionValue("dn");
            }
            if (line.hasOption("ca")) {
                this.adminCA = line.getOptionValue("ca");
            }
            if (line.hasOption("email")) {
                this.adminEmailAddress = line.getOptionValue("email");
            }
        }
        catch (ParseException e) {
            throw new VOMSException("Error parsing command-line arguments: " + e.getMessage(), e);
        }
    }

    private void printHelpMessageAndExit(int exitStatus) {
        this.helpFormatter.printHelp("SchemaDeployer", this.options);
        System.exit(exitStatus);
    }

    private int dropTable(String tableName) {
        org.hibernate.Session s = HibernateFactory.getSession();
        String command = "drop table " + tableName;
        return s.createSQLQuery(command).executeUpdate();
    }

    private void dropUnusedTables_2_0_x() {
        String[] tableNames;
        for (String table : tableNames = new String[]{"admins_history", "history"}) {
            this.dropTable(table);
        }
    }

    private void dropOldTables_2_0_x() {
        DatabaseMetaData md = null;
        try {
            md = HibernateFactory.getSession().connection().getMetaData();
        }
        catch (Throwable t) {
            log.error("Error accessing database metadata!", t);
            System.exit(-1);
        }
        ResultSet oldTables = this.getTableNamesMatchingPattern(md, "%_old");
        ArrayList<String> toBeDropped = new ArrayList<String>();
        try {
            while (oldTables.next()) {
                toBeDropped.add(oldTables.getString("TABLE_NAME"));
            }
        }
        catch (SQLException e) {
            log.error("Error reading table names from database metadata!", (Throwable)e);
            System.exit(2);
        }
        for (String tableName : toBeDropped) {
            log.debug("Dropping '" + tableName + "'...");
            this.dropTable(tableName);
        }
    }

    private void dropOldTables_1_2_19() {
        String[] dTables = new String[]{"acl_old", "acld", "admins_old", "attributes_old", "ca_old", "capabilities_old", "capabilitiesd", "group_attrs_old", "groups_old", "groupsd", "m_old", "md", "periodicity", "realtime", "requests_old", "role_attrs_old", "roles_old", "rolesd", "seqnumber_old", "sequences", "usr_old", "usr_attrs_old", "usrd", "version_old", "validity"};
        for (int i = 0; i < dTables.length; ++i) {
            this.dropTable(dTables[i]);
        }
    }

    private int dropSequence(String sequenceName) {
        log.debug("Dropping sequence " + sequenceName);
        org.hibernate.Session s = HibernateFactory.getSession();
        String command = "drop sequence " + sequenceName;
        try {
            return s.createSQLQuery(command).executeUpdate();
        }
        catch (HibernateException e) {
            if (e.getCause().getMessage().contains("sequence does not exist")) {
                log.warn("Error dropping sequence: " + sequenceName + "... such sequence doesn't exist.");
                log.warn("This error may be ignored at this stage of the database upgrade...");
            }
            return 0;
        }
    }

    private void dropOldSequences() {
        log.info("Dropping old sequences...");
        String[] oldSequences = new String[]{"voms_seq_ca", "voms_seq_transaction", "voms_seq_admin", "voms_seq_acl", "voms_seq_role", "voms_seq_group", "voms_seq_user"};
        for (int i = 0; i < oldSequences.length; ++i) {
            this.dropSequence(oldSequences[i]);
        }
    }

    private int renameTable(String tableName) {
        org.hibernate.Session s = HibernateFactory.getSession();
        String command = "alter table " + tableName + " rename to " + tableName + "_old";
        return s.createSQLQuery(command).executeUpdate();
    }

    private void renameTables_1_2_19() {
        String[] oldTables = new String[]{"ca", "acl", "admins", "attributes", "capabilities", "group_attrs", "groups", "role_attrs", "roles", "seqnumber", "usr", "usr_attrs", "m", "requests", "version"};
        for (int i = 0; i < oldTables.length; ++i) {
            this.renameTable(oldTables[i]);
        }
    }

    private void fixHibernateSequence() {
        log.info("Migrating sequences since on oracle backend...");
        org.hibernate.Session s = HibernateFactory.getSession();
        Long maxSeqValue = (Long)s.createSQLQuery("select max(last_number) as max from user_sequences where sequence_name like 'VOMS_%'").addScalar("max", (Type)new LongType()).uniqueResult();
        String dropHibSeqStatement = "drop sequence HIBERNATE_SEQUENCE";
        String createHibSeqStatement = "create sequence HIBERNATE_SEQUENCE MINVALUE 1 MAXVALUE 999999999999999999999999999 INCREMENT BY 1 START WITH " + maxSeqValue + " CACHE 20 NOORDER NOCYCLE";
        s.createSQLQuery(dropHibSeqStatement).executeUpdate();
        s.createSQLQuery(createHibSeqStatement).executeUpdate();
        log.info("Sequences migration complete.");
    }

    private void renameTables_2_0_x() {
        String[] tables20x;
        for (String tableName : tables20x = new String[]{"acl2", "acl2_permissions", "admins", "admins_history", "attributes", "ca", "capabilities", "group_attrs", "groups", "history", "m", "memb_req", "role_attrs", "roles", "seqnumber", "usr", "usr_attrs", "version"}) {
            this.renameTable(tableName);
        }
    }

    private void executeAndLog(String command) {
        log.info("Executing '" + command + "'");
        HibernateFactory.getSession().createSQLQuery(command).executeUpdate();
    }

    private void fixCaTable() throws HibernateException, SQLException {
        this.executeAndLog("update ca set subject_string = ca");
        HibernateFactory.getSession().createSQLQuery("update ca set creation_time = :creationTime").setTimestamp("creationTime", new Date()).executeUpdate();
        this.dropColumn("ca", "ca");
        this.setColumnNullability(false, "ca", "subject_string", this.getVarcharType() + "(255)");
        this.setColumnNullability(false, "ca", "creation_time", this.getTimestampType());
    }

    private String getColumnType(String tableName, String columnName) throws HibernateException, SQLException {
        DatabaseMetaData md = HibernateFactory.getSession().connection().getMetaData();
        ResultSet columnData = md.getColumns("%", "%", tableName, columnName);
        int matches = 0;
        if (columnData.next()) {
            ++matches;
            String typeName = columnData.getString("TYPE_NAME");
            int colSize = columnData.getInt("COLUMN_SIZE");
            if (colSize > 0) {
                typeName = typeName + "(" + colSize + ")";
            }
            log.debug(String.format("%s.%s type:%s colSize:%s", tableName, columnName, typeName, colSize));
            return typeName;
        }
        return null;
    }

    private void setColumnNullability(boolean nullable, String tableName, String columnName, String typeName) {
        String nullString = nullable ? "" : "not";
        String command = String.format("alter table %s modify %s %s %s null", tableName, columnName, typeName, nullString);
        this.executeAndLog(command);
    }

    private void dropColumn(String tableName, String columnName) {
        this.executeAndLog(String.format("alter table %s drop column %s", tableName, columnName));
    }

    private List<String> getForeignKeyContraintNamesOnColumn(String tableName, String columnName) throws SQLException {
        DatabaseMetaData md = HibernateFactory.getSession().connection().getMetaData();
        ResultSet rs = md.getImportedKeys(null, null, tableName);
        ArrayList<String> res = new ArrayList<String>();
        while (rs.next()) {
            String importedPkTableName = rs.getString("PKTABLE_NAME");
            String importedPkColumnName = rs.getString("PKCOLUMN_NAME");
            String fkName = rs.getString("FK_NAME");
            String pkName = rs.getString("PK_NAME");
            res.add(fkName);
        }
        return res;
    }

    private void updateACLPerms() {
        this.executeAndLog("update acl2_permissions set permissions = 16383 where permissions = 4095");
    }

    private void dropOrphanedAdministrators() {
        List<VOMSAdmin> orphanedAdmins = ACLDAO.instance().getAdminsWithoutActivePermissions();
        for (VOMSAdmin a : orphanedAdmins) {
            log.info("Dropping orphaned administrator '{}' - email: '{}'", (Object)a.getDn(), (Object)a.getEmailAddress());
            HibernateFactory.getSession().delete((Object)a);
        }
    }

    private void fixUsrTable() throws HibernateException, SQLException {
        this.executeAndLog("update usr set email_address = mail");
        this.dropColumn("usr", "mail");
        this.dropColumn("usr", "cn");
        this.dropColumn("usr", "cauri");
        this.setColumnNullability(false, "usr", "creation_time", this.getTimestampType());
        this.setColumnNullability(false, "usr", "end_time", this.getTimestampType());
        this.setColumnNullability(true, "usr", "dn", this.getVarcharType() + "(255)");
        if (!this.isOracleBackend()) {
            this.setColumnNullability(true, "usr", "ca", "smallint");
        }
        String dropForeignKeyString = this.dialect.getDropForeignKeyString();
        this.executeAndLog("alter table usr " + dropForeignKeyString + " fk_usr_ca");
        this.executeAndLog("update usr set dn = null");
        this.executeAndLog("update usr set ca = null");
    }

    private void migrateUsrTable() {
        CertificateDAO certDAO = CertificateDAO.instance();
        Iterator userIterator = HibernateFactory.getSession().createQuery("select u, u.dn, u.ca from VOMSUser u").iterate();
        while (userIterator.hasNext()) {
            Object[] result = (Object[])userIterator.next();
            VOMSUser u = (VOMSUser)result[0];
            String dn = (String)result[1];
            VOMSCA ca = (VOMSCA)result[2];
            Certificate candidateCert = certDAO.findByDNCA(dn, ca.getSubjectString());
            if (candidateCert != null) {
                log.warn("**** WARNING *****");
                log.warn("There is a duplicated entry in the database for user: '{}','{}'", (Object)dn, (Object)ca.getSubjectString());
                log.warn("The duplicated entry will be REMOVED.\n");
                HibernateFactory.getSession().createSQLQuery("delete from m where userid = :id").setLong("id", u.getId().longValue()).executeUpdate();
                HibernateFactory.getSession().createSQLQuery("delete from usr_attrs where u_id = :id").setLong("id", u.getId().longValue()).executeUpdate();
                HibernateFactory.getSession().createSQLQuery("delete from usr where userid = :id").setLong("id", u.getId().longValue()).executeUpdate();
                continue;
            }
            candidateCert = certDAO.create(u, ca.getSubjectString());
            u.addCertificate(candidateCert);
            u.setEmailAddress("temporary_value");
            u.setCreationTime(new Date());
            Calendar c = Calendar.getInstance();
            c.setTime(u.getCreationTime());
            int lifetime = VOMSConfiguration.instance().getInt("voms.membership.default_lifetime", 12);
            c.add(2, lifetime);
            u.setEndTime(c.getTime());
            HibernateFactory.getSession().save((Object)u);
        }
    }

    private void migrateDbContents() {
        log.info("Migrating db contents...");
        org.hibernate.Session s = HibernateFactory.getSession();
        s.createSQLQuery("insert into ca (cid, ca, cadescr) select cid, ca, cadescr from ca_old").executeUpdate();
        s.createSQLQuery("insert into admins(adminid,dn,ca) select adminid, dn,ca from admins_old").executeUpdate();
        s.createSQLQuery("insert into groups(gid,dn,parent,must) select gid,dn,parent,must from groups_old").executeUpdate();
        s.createSQLQuery("insert into roles(rid,role) select rid, role from roles_old").executeUpdate();
        s.createSQLQuery("insert into usr(userid,dn,ca,cn,mail,cauri) select userid, dn, ca, cn, mail, cauri from usr_old").executeUpdate();
        s.createSQLQuery("update usr set suspended = false").executeUpdate();
        s.createSQLQuery("insert into version values('3')").executeUpdate();
        s.createSQLQuery("insert into attributes(a_id, a_name, a_desc) select a_id,a_name,a_desc from attributes_old").executeUpdate();
        s.createSQLQuery("insert into usr_attrs(u_id,a_id,a_value) select u_id,a_id,a_value from usr_attrs_old").executeUpdate();
        s.createSQLQuery("insert into group_attrs(g_id,a_id,a_value) select g_id,a_id,a_value from group_attrs_old").executeUpdate();
        s.createSQLQuery("insert into role_attrs(r_id,g_id,a_id,a_value) select r_id, g_id,a_id,a_value from role_attrs_old").executeUpdate();
        s.createSQLQuery("insert into seqnumber(seq) select seq from seqnumber_old").executeUpdate();
    }

    private void migrateMappings() {
        Object[] result;
        org.hibernate.Session s = HibernateFactory.getSession();
        List oldMappings = s.createSQLQuery("select userid,gid,rid,cid from m_old").addScalar("userid", (Type)new LongType()).addScalar("gid", (Type)new LongType()).addScalar("rid", (Type)new LongType()).addScalar("cid", (Type)new LongType()).list();
        Iterator i = oldMappings.iterator();
        VOMSUserDAO dao = VOMSUserDAO.instance();
        while (i.hasNext() && (result = (Object[])i.next()) != null) {
            VOMSUser u = dao.findById((Long)result[0]);
            VOMSGroup g = VOMSGroupDAO.instance().findById((Long)result[1]);
            VOMSRole r = null;
            if (result[2] != null) {
                r = VOMSRoleDAO.instance().findById((Long)result[2]);
            }
            log.debug("Mapping: " + u + "," + g + "," + r);
            if (r == null) {
                if (!u.isMember(g)) {
                    dao.addToGroup(u, g);
                }
            } else {
                if (!u.isMember(g)) {
                    dao.addToGroup(u, g);
                }
                VOMSUserDAO.instance().assignRole(u, g, r);
            }
            s.save((Object)u);
        }
    }

    private void removeDuplicatedACLEntries() {
        log.info("Removing eventual buggy duplicated ACL entries... ");
        org.hibernate.Session s = HibernateFactory.getSession();
        s.createSQLQuery("delete from admins_old where dn not like '/O=VOMS/%' and adminid not in (select adminid from acl_old)").executeUpdate();
    }

    private void migrateACLs() {
        for (VOMSAdmin a : VOMSAdminDAO.instance().getAll()) {
            List perms;
            long adminId = a.getId();
            if (!a.getDn().equals("/O=VOMS/O=System/CN=Any Authenticated User") && a.getDn().startsWith("/O=VOMS")) continue;
            log.debug("Migrating acls for admin : " + a.getDn());
            MultiHashMap m = this.loadDefaultACLEntriesForAdmin(adminId);
            if (m != null) {
                Iterator keys = m.keySet().iterator();
                while (keys.hasNext()) {
                    List perms2 = (List)m.get(keys.next());
                    this.setGlobalPermission(a, ACLMapper.translatePermissions(perms2));
                }
            }
            if ((m = this.loadGroupACLEntriesForAdmin(adminId)) != null) {
                for (Long groupId : m.keySet()) {
                    perms = (List)m.get((Object)groupId);
                    VOMSGroup targetGroup = VOMSGroupDAO.instance().findById(groupId);
                    targetGroup.getACL().setPermissions(a, ACLMapper.translatePermissions(perms));
                }
            }
            if ((m = this.loadRoleACLEntriesForAdmin(adminId)) == null) continue;
            for (Long roleId : m.keySet()) {
                perms = (List)m.get((Object)roleId);
                VOMSRole targetRole = VOMSRoleDAO.instance().findById(roleId);
                this.setPermissionOnRole(a, targetRole, ACLMapper.translatePermissions(perms));
            }
        }
    }

    public static void main(String[] args) throws ConfigurationException {
        new SchemaDeployer(args);
    }

    private MultiHashMap buildACLEntries(List acl) {
        if (acl.isEmpty()) {
            return null;
        }
        MultiHashMap map = new MultiHashMap();
        for (Object[] res : acl) {
            map.put(res[0], res[1]);
        }
        return map;
    }

    private MultiHashMap loadGroupACLEntriesForAdmin(long adminid) {
        org.hibernate.Session s = HibernateFactory.getSession();
        String query = "select groups.gid as gid, acl.operation as operation from acl_old acl, groups_old groups where acl.aid = groups.aclid and acl.allow = 1 and adminid = :adminId";
        List acls = s.createSQLQuery(query).addScalar("gid", (Type)new LongType()).addScalar("operation", (Type)new ShortType()).setLong("adminId", adminid).list();
        return this.buildACLEntries(acls);
    }

    private MultiHashMap loadDefaultACLEntriesForAdmin(long adminid) {
        org.hibernate.Session s = HibernateFactory.getSession();
        String query = "select -1 as gid, acl.operation as operation from acl_old acl, groups_old groups where acl.aid = 0 and acl.allow = 1 and adminid = :adminId";
        List acls = s.createSQLQuery(query).addScalar("gid", (Type)new LongType()).addScalar("operation", (Type)new ShortType()).setLong("adminId", adminid).list();
        return this.buildACLEntries(acls);
    }

    private MultiHashMap loadRoleACLEntriesForAdmin(long adminid) {
        org.hibernate.Session s = HibernateFactory.getSession();
        String query = "select roles.rid as rid, acl.operation as operation from acl_old acl, roles_old roles where acl.aid = roles.aclid and acl.allow = 1 and adminid = :adminId";
        List acls = s.createSQLQuery(query).addScalar("rid", (Type)new LongType()).addScalar("operation", (Type)new ShortType()).setLong("adminId", adminid).list();
        return this.buildACLEntries(acls);
    }

    private void setPermissionOnRole(VOMSAdmin a, VOMSRole r, VOMSPermission p) {
        log.debug("Setting permissions " + p.getCompactRepresentation() + " for admin " + a.getDn() + " on role " + r.getName());
        List groups = VOMSGroupDAO.instance().findAll();
        for (VOMSGroup g : groups) {
            ACL roleACL = r.getACL(g);
            if (roleACL == null) {
                roleACL = new ACL(g, r, false);
                roleACL.setPermissions(a, p);
                r.getAcls().add(roleACL);
                continue;
            }
            roleACL.setPermissions(a, p);
        }
    }

    private void setGlobalPermission(VOMSAdmin a, VOMSPermission p) {
        log.debug("Setting global permissions " + p.getCompactRepresentation() + " for admin " + a.getDn());
        List groups = VOMSGroupDAO.instance().findAll();
        List roles = VOMSRoleDAO.instance().getAll();
        for (VOMSGroup g : groups) {
            ACL acl = g.getACL();
            if (acl == null) {
                acl = new ACL(g, false);
                acl.setPermissions(a, p);
                g.getAcls().add(acl);
            } else {
                acl.setPermissions(a, p);
            }
            for (VOMSRole r : roles) {
                ACL roleACL = r.getACL(g);
                if (roleACL == null) {
                    roleACL = new ACL(g, r, false);
                    roleACL.setPermissions(a, p);
                    r.getAcls().add(roleACL);
                    continue;
                }
                roleACL.setPermissions(a, p);
            }
        }
    }
}

