/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.dao.hibernate;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.error.NullArgumentException;
import org.glite.security.voms.admin.persistence.dao.generic.DAOFactory;
import org.glite.security.voms.admin.persistence.dao.generic.TaskDAO;
import org.glite.security.voms.admin.persistence.dao.generic.TaskTypeDAO;
import org.glite.security.voms.admin.persistence.dao.hibernate.GenericHibernateDAO;
import org.glite.security.voms.admin.persistence.error.VOMSDatabaseException;
import org.glite.security.voms.admin.persistence.model.AUP;
import org.glite.security.voms.admin.persistence.model.request.Request;
import org.glite.security.voms.admin.persistence.model.task.ApproveUserRequestTask;
import org.glite.security.voms.admin.persistence.model.task.SignAUPTask;
import org.glite.security.voms.admin.persistence.model.task.Task;
import org.glite.security.voms.admin.persistence.model.task.TaskType;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskDAOHibernate
extends GenericHibernateDAO<Task, Long>
implements TaskDAO {
    private static final Logger log = LoggerFactory.getLogger(TaskDAOHibernate.class);

    @Override
    public ApproveUserRequestTask createApproveUserRequestTask(Request req) {
        return null;
    }

    @Override
    public SignAUPTask createSignAUPTask(AUP aup, Date expiryDate) {
        TaskTypeDAO ttDAO = DAOFactory.instance(DAOFactory.HIBERNATE).getTaskTypeDAO();
        if (aup == null) {
            throw new NullArgumentException("aup cannot be null!");
        }
        if (expiryDate == null) {
            throw new NullArgumentException("expiryDate cannot be null!");
        }
        TaskType tt = ttDAO.findByName("SignAUPTask");
        if (tt == null) {
            throw new VOMSDatabaseException("Inconsistent database! Task type for SignAUPTask not found in database!");
        }
        SignAUPTask t = new SignAUPTask(tt, aup, expiryDate);
        this.makePersistent(t);
        return t;
    }

    @Override
    public List<Task> findApproveUserRequestTasks() {
        return this.findConcrete(ApproveUserRequestTask.class);
    }

    protected List<Task> findConcrete(Class clazz) {
        return this.getSession().createCriteria(clazz).list();
    }

    @Override
    public List<Task> findSignAUPTasks() {
        return this.findConcrete(SignAUPTask.class);
    }

    @Override
    public void removeAllTasks() {
        List tasks = this.findAll();
        for (Task t : tasks) {
            this.makeTransient(t);
        }
    }

    @Override
    public SignAUPTask createSignAUPTask(AUP aup) {
        int lifetime = VOMSConfiguration.instance().getInt("voms.aup.sign_aup_task_lifetime", 15);
        Calendar cal = Calendar.getInstance();
        if (lifetime > 0) {
            cal.add(6, lifetime);
        }
        log.debug("Scheduling SignAUP task with expiration date: {}", (Object)cal.getTime().toString());
        return this.createSignAUPTask(aup, cal.getTime());
    }

    @Override
    public List<Task> getActiveTasks() {
        return this.findByCriteria(new Criterion[]{Restrictions.ne((String)"status", (Object)((Object)Task.TaskStatus.COMPLETED)), Restrictions.ne((String)"status", (Object)((Object)Task.TaskStatus.EXPIRED))});
    }
}

