/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.dao.hibernate;

import java.util.List;
import org.glite.security.voms.admin.error.NullArgumentException;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.persistence.dao.generic.TagDAO;
import org.glite.security.voms.admin.persistence.dao.hibernate.GenericHibernateDAO;
import org.glite.security.voms.admin.persistence.error.AlreadyExistsException;
import org.glite.security.voms.admin.persistence.model.Tag;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class TagDAOHibernate
extends GenericHibernateDAO<Tag, Long>
implements TagDAO {
    @Override
    public Tag findByName(String name) {
        if (name == null) {
            throw new NullArgumentException("name cannot be null!");
        }
        List retVal = this.findByCriteria(new Criterion[]{Restrictions.eq((String)"name", (Object)name)});
        if (retVal.isEmpty()) {
            return null;
        }
        return (Tag)retVal.get(0);
    }

    @Override
    public Tag createTag(String name, VOMSPermission perm, VOMSPermission permOnPath, boolean implicit) {
        if (name == null) {
            throw new NullArgumentException("name cannot be null!");
        }
        if (perm == null) {
            throw new NullArgumentException("perm cannot be null!");
        }
        Tag t = this.findByName(name);
        if (t != null) {
            throw new AlreadyExistsException("Tag named '" + name + "' already exists.");
        }
        t = new Tag(name, perm, permOnPath, implicit);
        this.getSession().save((Object)t);
        return t;
    }
}

