/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.dao.hibernate;

import java.util.List;
import org.glite.security.voms.admin.persistence.dao.generic.AUPDAO;
import org.glite.security.voms.admin.persistence.dao.generic.AUPVersionDAO;
import org.glite.security.voms.admin.persistence.dao.generic.DAOFactory;
import org.glite.security.voms.admin.persistence.dao.generic.GroupDAO;
import org.glite.security.voms.admin.persistence.dao.generic.RequestDAO;
import org.glite.security.voms.admin.persistence.dao.generic.RequesterInfoDAO;
import org.glite.security.voms.admin.persistence.dao.generic.TagDAO;
import org.glite.security.voms.admin.persistence.dao.generic.TaskDAO;
import org.glite.security.voms.admin.persistence.dao.generic.TaskLogRecordDAO;
import org.glite.security.voms.admin.persistence.dao.generic.TaskTypeDAO;
import org.glite.security.voms.admin.persistence.dao.generic.UserDAO;
import org.glite.security.voms.admin.persistence.dao.hibernate.AUPDAOHibernate;
import org.glite.security.voms.admin.persistence.dao.hibernate.GenericHibernateDAO;
import org.glite.security.voms.admin.persistence.dao.hibernate.NamedEntityHibernateDAO;
import org.glite.security.voms.admin.persistence.dao.hibernate.RequestDAOHibernate;
import org.glite.security.voms.admin.persistence.dao.hibernate.TagDAOHibernate;
import org.glite.security.voms.admin.persistence.dao.hibernate.TaskDAOHibernate;
import org.glite.security.voms.admin.persistence.model.AUPVersion;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.glite.security.voms.admin.persistence.model.request.RequesterInfo;
import org.glite.security.voms.admin.persistence.model.task.LogRecord;
import org.glite.security.voms.admin.persistence.model.task.Task;
import org.glite.security.voms.admin.persistence.model.task.TaskType;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateDAOFactory
extends DAOFactory {
    private static Logger log = LoggerFactory.getLogger(HibernateDAOFactory.class);

    @Override
    public AUPDAO getAUPDAO() {
        return (AUPDAO)((Object)this.instantiateDAO(AUPDAOHibernate.class));
    }

    @Override
    public AUPVersionDAO getAUPVersionDAO() {
        return (AUPVersionDAO)((Object)this.instantiateDAO(AUPVersionDAOHibernate.class));
    }

    @Override
    public GroupDAO getGroupDAO() {
        return (GroupDAO)((Object)this.instantiateDAO(GroupDAOHibernate.class));
    }

    @Override
    public RequestDAO getRequestDAO() {
        return (RequestDAO)((Object)this.instantiateDAO(RequestDAOHibernate.class));
    }

    @Override
    public RequesterInfoDAO getRequesterInfoDAO() {
        return (RequesterInfoDAO)((Object)this.instantiateDAO(RequesterInfoDAOHibernate.class));
    }

    @Override
    public TagDAO getTagDAO() {
        return (TagDAO)((Object)this.instantiateDAO(TagDAOHibernate.class));
    }

    @Override
    public TaskDAO getTaskDAO() {
        return (TaskDAO)((Object)this.instantiateDAO(TaskDAOHibernate.class));
    }

    @Override
    public TaskLogRecordDAO getTaskLogRecordDAO() {
        return (TaskLogRecordDAO)((Object)this.instantiateDAO(TaskLogRecordDAOHibernate.class));
    }

    @Override
    public TaskTypeDAO getTaskTypeDAO() {
        return (TaskTypeDAO)((Object)this.instantiateDAO(TaskTypeDAOHibernate.class));
    }

    @Override
    public UserDAO getUserDAO() {
        return (UserDAO)((Object)this.instantiateDAO(UserDAOHibernate.class));
    }

    private GenericHibernateDAO instantiateDAO(Class daoClass) {
        try {
            log.debug("Instantiating DAO: " + daoClass);
            return (GenericHibernateDAO)daoClass.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Can not instantiate DAO: " + daoClass, ex);
        }
    }

    public static class TaskTypeDAOHibernate
    extends NamedEntityHibernateDAO<TaskType, Long>
    implements TaskTypeDAO {
    }

    public static class TaskLogRecordDAOHibernate
    extends GenericHibernateDAO<LogRecord, Long>
    implements TaskLogRecordDAO {
        @Override
        public void deleteForTask(Task t) {
        }

        @Override
        public List<LogRecord> findForTask(Task t) {
            LogRecord lr = new LogRecord();
            lr.setTask(t);
            return this.findByCriteria(new Criterion[]{Restrictions.eq((String)"task", (Object)t)});
        }
    }

    public static class RequesterInfoDAOHibernate
    extends GenericHibernateDAO<RequesterInfo, Long>
    implements RequesterInfoDAO {
    }

    public static class UserDAOHibernate
    extends NamedEntityHibernateDAO<VOMSUser, Long>
    implements UserDAO {
    }

    public static class GroupDAOHibernate
    extends NamedEntityHibernateDAO<VOMSGroup, Long>
    implements GroupDAO {
    }

    public static class AUPVersionDAOHibernate
    extends GenericHibernateDAO<AUPVersion, Long>
    implements AUPVersionDAO {
    }
}

