/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.dao.hibernate;

import java.net.URL;
import java.util.Date;
import java.util.List;
import org.glite.security.voms.admin.error.NullArgumentException;
import org.glite.security.voms.admin.error.VOMSException;
import org.glite.security.voms.admin.persistence.dao.generic.AUPDAO;
import org.glite.security.voms.admin.persistence.dao.hibernate.NamedEntityHibernateDAO;
import org.glite.security.voms.admin.persistence.error.AlreadyExistsException;
import org.glite.security.voms.admin.persistence.error.NoSuchAUPVersionException;
import org.glite.security.voms.admin.persistence.model.AUP;
import org.glite.security.voms.admin.persistence.model.AUPAcceptanceRecord;
import org.glite.security.voms.admin.persistence.model.AUPVersion;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class AUPDAOHibernate
extends NamedEntityHibernateDAO<AUP, Long>
implements AUPDAO {
    protected AUP newAUP(String name, String description) {
        if (name == null) {
            throw new NullArgumentException("name cannot be null!");
        }
        if (this.findByName(name) != null) {
            throw new AlreadyExistsException("AUP named '" + name + "' already exists!");
        }
        AUP aup = new AUP();
        aup.setName(name);
        aup.setDescription(description);
        aup.setReacceptancePeriod(365);
        return aup;
    }

    protected AUP createAUP(String name, String description, String version, String text) {
        if (version == null) {
            throw new NullArgumentException("version cannot be null!");
        }
        if (text == null) {
            throw new NullArgumentException("text cannot be null!");
        }
        AUP aup = this.newAUP(name, description);
        AUPVersion firstVersion = this.newAUPVersion(aup, version);
        firstVersion.setText(text);
        firstVersion.setActive(true);
        aup.getVersions().add(firstVersion);
        this.makePersistent(aup);
        return aup;
    }

    protected AUP createAUP(String name, String description, String version, URL url) {
        if (version == null) {
            throw new NullArgumentException("version cannot be null!");
        }
        if (url == null) {
            throw new NullArgumentException("url cannot be null!");
        }
        AUP aup = this.newAUP(name, description);
        AUPVersion firstVersion = this.newAUPVersion(aup, version);
        firstVersion.setUrl(url.toString());
        firstVersion.setActive(true);
        aup.getVersions().add(firstVersion);
        this.makePersistent(aup);
        return aup;
    }

    protected AUPVersion newAUPVersion(AUP aup, String version) {
        if (aup == null) {
            throw new NullArgumentException("aup cannot be null!");
        }
        AUPVersion aupVersion = aup.getVersion(version);
        if (aupVersion != null) {
            throw new AlreadyExistsException("Version '" + version + "' already exists for AUP named '" + aup.getName() + "'.");
        }
        if (version == null) {
            throw new NullArgumentException("version cannot be null!");
        }
        aupVersion = new AUPVersion();
        aupVersion.setVersion(version);
        aupVersion.setCreationTime(new Date());
        aupVersion.setAup(aup);
        return aupVersion;
    }

    @Override
    public void addVersion(AUP aup, String version, URL url) {
        AUPVersion v = this.newAUPVersion(aup, version);
        v.setUrl(url.toString());
        aup.getVersions().add(v);
    }

    @Override
    public void addVersion(AUP aup, String version, String text) {
        AUPVersion v = this.newAUPVersion(aup, version);
        v.setText(text);
        aup.getVersions().add(v);
    }

    @Override
    public AUPVersion removeVersion(AUP aup, String version) {
        if (aup == null) {
            throw new NullArgumentException("aup cannot be null!");
        }
        AUPVersion aupVersion = aup.getVersion(version);
        if (aupVersion == null) {
            throw new NoSuchAUPVersionException("No AUP version found for version '" + version + "'.");
        }
        if (aupVersion.getActive().booleanValue()) {
            throw new VOMSException("The currently active aup version cannot be removed!");
        }
        this.dropAcceptanceRecordsForAUPVersion(aupVersion);
        aup.getVersions().remove(aupVersion);
        return aupVersion;
    }

    @Override
    public AUP getGridAUP() {
        return (AUP)this.findByName("GRID-AUP");
    }

    @Override
    public AUP getVOAUP() {
        return (AUP)this.findByName("VO-AUP");
    }

    @Override
    public AUP createGridAUP(String description, String version, URL url) {
        return this.createAUP("GRID-AUP", description, version, url);
    }

    @Override
    public AUP createGridAUP(String description, String version, String text) {
        return this.createAUP("GRID-AUP", description, version, text);
    }

    @Override
    public AUP createVOAUP(String description, String version, URL url) {
        return this.createAUP("VO-AUP", description, version, url);
    }

    @Override
    public AUP createVOAUP(String description, String version, String text) {
        return this.createAUP("VO-AUP", description, version, text);
    }

    @Override
    public void setActiveVersion(AUP aup, String version) {
        if (aup == null) {
            throw new NullArgumentException("aup cannot be null!");
        }
        if (version == null) {
            throw new NullArgumentException("version cannot be null!");
        }
        AUPVersion v = aup.getVersion(version);
        if (v == null) {
            throw new NoSuchAUPVersionException("Aup version '" + version + "' not defined for AUP '" + aup.getName() + "'.");
        }
        aup.setActiveVersion(v);
    }

    private void dropAcceptanceRecordsForAUPVersion(AUPVersion aupVersion) {
        Criteria crit = this.getSession().createCriteria(AUPAcceptanceRecord.class).add((Criterion)Restrictions.eq((String)"aupVersion", (Object)aupVersion));
        List records = crit.list();
        for (AUPAcceptanceRecord r : records) {
            r.getUser().getAupAcceptanceRecords().remove(r);
            r.setUser(null);
            r.setAupVersion(null);
            this.getSession().delete((Object)r);
        }
    }
}

