/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.dao.generic;

import org.glite.security.voms.admin.persistence.dao.generic.AUPDAO;
import org.glite.security.voms.admin.persistence.dao.generic.AUPVersionDAO;
import org.glite.security.voms.admin.persistence.dao.generic.GroupDAO;
import org.glite.security.voms.admin.persistence.dao.generic.RequestDAO;
import org.glite.security.voms.admin.persistence.dao.generic.RequesterInfoDAO;
import org.glite.security.voms.admin.persistence.dao.generic.TagDAO;
import org.glite.security.voms.admin.persistence.dao.generic.TaskDAO;
import org.glite.security.voms.admin.persistence.dao.generic.TaskLogRecordDAO;
import org.glite.security.voms.admin.persistence.dao.generic.TaskTypeDAO;
import org.glite.security.voms.admin.persistence.dao.generic.UserDAO;
import org.glite.security.voms.admin.persistence.dao.hibernate.HibernateDAOFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DAOFactory {
    private static Logger log = LoggerFactory.getLogger(DAOFactory.class);
    public static final Class HIBERNATE = HibernateDAOFactory.class;

    public static DAOFactory instance(Class factory) {
        try {
            log.debug("Creating concrete DAO factory: " + factory);
            return (DAOFactory)factory.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Couldn't create DAOFactory: " + factory);
        }
    }

    public static DAOFactory instance() {
        return DAOFactory.instance(HIBERNATE);
    }

    public abstract AUPDAO getAUPDAO();

    public abstract AUPVersionDAO getAUPVersionDAO();

    public abstract TagDAO getTagDAO();

    public abstract TaskDAO getTaskDAO();

    public abstract TaskTypeDAO getTaskTypeDAO();

    public abstract TaskLogRecordDAO getTaskLogRecordDAO();

    public abstract RequestDAO getRequestDAO();

    public abstract RequesterInfoDAO getRequesterInfoDAO();

    public abstract GroupDAO getGroupDAO();

    public abstract UserDAO getUserDAO();
}

