/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.dao;

import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.core.VOMSServiceConstants;
import org.glite.security.voms.admin.persistence.HibernateFactory;
import org.glite.security.voms.admin.persistence.model.VOMSDBVersion;

public class VOMSVersionDAO {
    private VOMSVersionDAO() {
    }

    public static VOMSVersionDAO instance() {
        return new VOMSVersionDAO();
    }

    public VOMSDBVersion createCurrentVersion() {
        VOMSDBVersion v = new VOMSDBVersion();
        v.setVersion(VOMSServiceConstants.VOMS_DB_VERSION);
        v.setAdminVersion(VOMSConfiguration.instance().getString("voms-admin.server.version"));
        return v;
    }

    public void setupVersion() {
        VOMSDBVersion v = this.getVersion();
        if (v == null) {
            v = this.createCurrentVersion();
            HibernateFactory.getSession().save((Object)v);
        } else if (v.getVersion() != VOMSServiceConstants.VOMS_DB_VERSION) {
            HibernateFactory.getSession().delete((Object)v);
            HibernateFactory.getSession().save((Object)this.createCurrentVersion());
        } else {
            v.setAdminVersion(VOMSConfiguration.instance().getString("voms-admin.server.version"));
        }
    }

    public VOMSDBVersion getVersion() {
        return (VOMSDBVersion)HibernateFactory.getSession().createQuery("from VOMSDBVersion").uniqueResult();
    }
}

