/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.dao;

import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.error.NullArgumentException;
import org.glite.security.voms.admin.persistence.HibernateFactory;
import org.glite.security.voms.admin.persistence.dao.SearchResults;
import org.glite.security.voms.admin.persistence.dao.Searchable;
import org.glite.security.voms.admin.persistence.model.VOMSCA;
import org.glite.security.voms.admin.util.DNUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VOMSCADAO
implements Searchable {
    public static final Logger log = LoggerFactory.getLogger(VOMSCADAO.class);

    private VOMSCADAO() {
        HibernateFactory.beginTransaction();
    }

    public boolean createIfMissing(String caDN, String description) {
        VOMSCA ca = this.getByName(caDN);
        if (ca == null) {
            this.createCA(caDN, description);
            return true;
        }
        log.debug(caDN + " is already in the trusted CA database.");
        return false;
    }

    public VOMSCA createCA(String caDN, String description) {
        if (caDN == null) {
            throw new NullArgumentException("caDN must be non-null!");
        }
        log.info("Adding  '" + caDN + "' to trusted CA database.");
        VOMSCA ca = new VOMSCA(caDN, description);
        HibernateFactory.getSession().save((Object)ca);
        return ca;
    }

    public VOMSCA create(X509Certificate caCert, String description) {
        assert (caCert != null) : "CA certificate is null!";
        Date now = new Date();
        if (now.after(caCert.getNotAfter()) && !VOMSConfiguration.instance().getBoolean("voms.ca.create-when-expired", false)) {
            log.warn("CA '" + DNUtil.getOpenSSLSubject(caCert.getSubjectX500Principal()) + "' certificate has expired on " + caCert.getNotAfter() + " so it will not be added to the voms database!");
            return null;
        }
        VOMSCA ca = new VOMSCA(caCert, description);
        HibernateFactory.getSession().save((Object)ca);
        return ca;
    }

    public void saveOrUpdateTrustedCA(X509Certificate caCert) {
        this.saveOrUpdateTrustedCA(caCert, null);
    }

    public void checkValidityAndUpdate(VOMSCA ca, X509Certificate caCert) {
        Date now = new Date();
    }

    public void saveOrUpdateTrustedCA(X509Certificate caCert, String description) {
        assert (caCert != null) : "CA certificate is null!";
        VOMSCA ca = this.getFromCertificate(caCert);
        if (ca == null && (ca = this.create(caCert, description)) != null) {
            log.debug("Added [ " + ca.getSubjectString() + "] to trusted CA database.");
        }
    }

    public void saveTrustedCA(String caDN) {
        VOMSCA ca = this.getByName(caDN);
        if (ca == null) {
            log.debug("Adding [ " + caDN + "] to trusted CA database.");
            this.createCA(caDN, null);
        } else {
            log.debug(caDN + " is already in trusted CA database.");
        }
    }

    public VOMSCA getByName(String caDN) {
        if (caDN == null) {
            throw new NullArgumentException("caDN must be non-null!");
        }
        String queryString = "from VOMSCA as ca where ca.subjectString = :caDN";
        VOMSCA res = (VOMSCA)HibernateFactory.getSession().createQuery(queryString).setString("caDN", caDN).uniqueResult();
        return res;
    }

    public VOMSCA getByID(Short caID) {
        return (VOMSCA)HibernateFactory.getSession().get(VOMSCA.class, (Serializable)caID);
    }

    public VOMSCA getFromCertificate(X509Certificate cert) {
        VOMSCA model = new VOMSCA(cert, null);
        String query = "from VOMSCA as ca where ca.subjectString = :modelCA";
        VOMSCA result = (VOMSCA)HibernateFactory.getSession().createQuery(query).setString("modelCA", model.getSubjectString()).uniqueResult();
        return result;
    }

    public VOMSCA getByID(short caID) {
        return this.getByID(new Short(caID));
    }

    public List getAll() {
        String query = "from VOMSCA";
        List res = HibernateFactory.getSession().createQuery(query).list();
        return res;
    }

    public List getValid() {
        String query = "from VOMSCA where subjectString not like '/O=VOMS%' order by subjectString";
        List res = HibernateFactory.getSession().createQuery(query).list();
        return res;
    }

    public VOMSCA getGroupCA() {
        return this.getByName("/O=VOMS/O=System/CN=VOMS Group");
    }

    public VOMSCA getRoleCA() {
        return this.getByName("/O=VOMS/O=System/CN=VOMS Role");
    }

    public static VOMSCADAO instance() {
        return new VOMSCADAO();
    }

    @Override
    public int countMatches(String text) {
        if (text == null || "".equals(text.trim())) {
            return this.getValid().size();
        }
        String searchString = "%" + text + "%";
        String query = "select count(distinct ca) from VOMSCA ca where ca.subjectString not like '/O=VOMS%' and ca.subjectString like :searchString";
        int count = ((Long)HibernateFactory.getSession().createQuery(query).setString("searchString", searchString).uniqueResult()).intValue();
        return count;
    }

    @Override
    public SearchResults getAll(int firstResult, int maxResults) {
        String query = "from VOMSCA where subjectString not like '/O=VOMS%'";
        int count = this.getValid().size();
        List cas = HibernateFactory.getSession().createQuery(query).setFirstResult(firstResult).setMaxResults(maxResults).list();
        SearchResults results = SearchResults.instance();
        results.setCount(count);
        results.setFirstResult(firstResult);
        results.setResultsPerPage(maxResults);
        results.setResults(cas);
        results.setSearchString(null);
        return results;
    }

    @Override
    public SearchResults search(String text, int firstResult, int maxResults) {
        if (text == null || "".equals(text.trim()) || text.length() == 0) {
            return this.getAll(firstResult, maxResults);
        }
        String searchString = "%" + text + "%";
        String query = "select ca from VOMSCA ca where ca.subjectString not like '/O=VOMS%' and ca.subjectString like :searchString";
        List cas = HibernateFactory.getSession().createQuery(query).setString("searchString", searchString).setFirstResult(firstResult).setMaxResults(maxResults).list();
        SearchResults results = SearchResults.instance();
        results.setCount(this.countMatches(text));
        results.setFirstResult(firstResult);
        results.setResultsPerPage(maxResults);
        results.setResults(cas);
        results.setSearchString(text);
        return results;
    }
}

