/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.dao;

import java.util.Iterator;
import java.util.List;
import org.glite.security.voms.admin.persistence.HibernateFactory;
import org.glite.security.voms.admin.persistence.dao.SearchResults;
import org.glite.security.voms.admin.persistence.error.AlreadyExistsException;
import org.glite.security.voms.admin.persistence.error.NoSuchAttributeException;
import org.glite.security.voms.admin.persistence.model.VOMSAttributeDescription;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.hibernate.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VOMSAttributeDAO {
    public static final Logger log = LoggerFactory.getLogger(VOMSAttributeDAO.class);

    protected VOMSAttributeDAO() {
        HibernateFactory.beginTransaction();
    }

    public static VOMSAttributeDAO instance() {
        return new VOMSAttributeDAO();
    }

    public List getAllAttributeDescriptions() {
        String query = "from org.glite.security.voms.admin.persistence.model.VOMSAttributeDescription order by name";
        return HibernateFactory.getSession().createQuery(query).list();
    }

    public VOMSAttributeDescription createAttributeDescription(String name, String desc, boolean unique) {
        VOMSAttributeDescription attrDesc = this.getAttributeDescriptionByName(name);
        if (attrDesc != null) {
            throw new AlreadyExistsException("Attribute \"" + name + "\" already defined in database.");
        }
        attrDesc = new VOMSAttributeDescription(name, desc, unique);
        HibernateFactory.getSession().save((Object)attrDesc);
        return attrDesc;
    }

    public VOMSAttributeDescription createAttributeDescription(String name, String desc) {
        return this.createAttributeDescription(name, desc, false);
    }

    public VOMSAttributeDescription deleteAttributeDescription(String name) {
        VOMSAttributeDescription attrDesc = this.getAttributeDescriptionByName(name);
        if (attrDesc == null) {
            throw new NoSuchAttributeException("Attribute \"" + name + "\" not found in database.");
        }
        String[] attributeValueEntities = new String[]{"VOMSUserAttribute", "VOMSGroupAttribute", "VOMSRoleAttribute"};
        for (int i = 0; i < attributeValueEntities.length; ++i) {
            String query = "delete from org.glite.security.voms.admin.persistence.model." + attributeValueEntities[i] + " where attributeDescription = :desc";
            HibernateFactory.getSession().createQuery(query).setEntity("desc", (Object)attrDesc).executeUpdate();
        }
        HibernateFactory.getSession().delete((Object)attrDesc);
        return attrDesc;
    }

    public VOMSAttributeDescription getAttributeDescriptionByName(String name) {
        String query = "from org.glite.security.voms.admin.persistence.model.VOMSAttributeDescription where name = :name";
        VOMSAttributeDescription retVal = (VOMSAttributeDescription)HibernateFactory.getSession().createQuery(query).setString("name", name).uniqueResult();
        return retVal;
    }

    public List getUserAttributes() {
        String query = "select a.attributeDescription.name, u, a.value from org.glite.security.voms.admin.persistence.model.VOMSUser u join u.attributes a";
        return HibernateFactory.getSession().createQuery(query).list();
    }

    public List getGroupAttributes() {
        String query = "select a.attributeDescription.name, g, a.value from org.glite.security.voms.admin.persistence.model.VOMSGroup g join g.attributes a";
        return HibernateFactory.getSession().createQuery(query).list();
    }

    public List getRoleAttributes() {
        String query = "select a.attributeDescription.name, r, a.value from org.glite.security.voms.admin.persistence.model.VOMSRole r join r.attributes a";
        return HibernateFactory.getSession().createQuery(query).list();
    }

    public List getUserAttributes(String attributeName) {
        VOMSAttributeDescription desc = this.getAttributeDescriptionByName(attributeName);
        if (desc == null) {
            throw new NoSuchAttributeException("Attribute '" + attributeName + "' not found in database!");
        }
        return this.getUserAttributes(desc);
    }

    public List getGroupAttributes(String attributeName) {
        VOMSAttributeDescription desc = this.getAttributeDescriptionByName(attributeName);
        if (desc == null) {
            throw new NoSuchAttributeException("Attribute '" + attributeName + "' not found in database!");
        }
        return this.getGroupAttributes(desc);
    }

    public List getRoleAttributes(String attributeName) {
        VOMSAttributeDescription desc = this.getAttributeDescriptionByName(attributeName);
        if (desc == null) {
            throw new NoSuchAttributeException("Attribute '" + attributeName + "' not found in database!");
        }
        return this.getRoleAttributes(desc);
    }

    public List getGroupAttributes(VOMSAttributeDescription desc) {
        String query = "select g, a.value from org.glite.security.voms.admin.persistence.model.VOMSGroup g join g.attributes a where a.attributeDescription = :desc";
        return HibernateFactory.getSession().createQuery(query).setEntity("desc", (Object)desc).list();
    }

    public List getRoleAttributes(VOMSAttributeDescription desc) {
        String query = "select r, a.group, a.value from org.glite.security.voms.admin.persistence.model.VOMSRole r join r.attributes a where a.attributeDescription = :desc";
        return HibernateFactory.getSession().createQuery(query).setEntity("desc", (Object)desc).list();
    }

    public List getUserAttributes(VOMSAttributeDescription desc) {
        String query = "select u, a.value from org.glite.security.voms.admin.persistence.model.VOMSUser u join u.attributes a where a.attributeDescription = :desc";
        return HibernateFactory.getSession().createQuery(query).setEntity("desc", (Object)desc).list();
    }

    public SearchResults getAllUserAttributes(int firstResult, int maxResults) {
        SearchResults results = SearchResults.instance();
        String queryString = "select a.attributeDescription.name, u, a.value from org.glite.security.voms.admin.persistence.model.VOMSUser u join u.attributes a order by a.attributeDescription.name,u.dn";
        Query q = HibernateFactory.getSession().createQuery(queryString);
        q.setFirstResult(firstResult);
        q.setMaxResults(maxResults);
        results.setFirstResult(firstResult);
        results.setResultsPerPage(maxResults);
        results.setCount(this.countUserAttributes());
        results.setResults(q.list());
        return results;
    }

    public int countUserAttributes() {
        String queryString = "select count(*) from org.glite.security.voms.admin.persistence.model.VOMSUser u join u.attributes a";
        Long count = (Long)HibernateFactory.getSession().createQuery(queryString).uniqueResult();
        return count.intValue();
    }

    public int countUserAttributesMatches(String searchString) {
        String queryString = "select count(*) from org.glite.security.voms.admin.persistence.model.VOMSUser u join u.attributes a where (a.attributeDescription.name like :searchString) or (u.dn like :searchString) or (u.ca.subjectString like :searchString) or (a.value like :searchString)";
        String sString = "%" + searchString + "%";
        Query q = HibernateFactory.getSession().createQuery(queryString).setString("searchString", sString);
        Long count = (Long)q.uniqueResult();
        return count.intValue();
    }

    public SearchResults searchUserAttributes(String searchString, int firstResult, int maxResults) {
        if (searchString == null || searchString.equals("") || searchString.length() == 0) {
            return this.getAllUserAttributes(firstResult, maxResults);
        }
        SearchResults results = SearchResults.instance();
        String sString = "%" + searchString + "%";
        String queryString = "select a.attributeDescription.name, u, a.value from VOMSUser u join u.certificates c  join u.attributes a where (a.attributeDescription.name like :searchString) or (c.subjectString like :searchString) or (c.ca.subjectString like :searchString) or (a.value like :searchString) order by a.attributeDescription.name,c.subjectString";
        Query q = HibernateFactory.getSession().createQuery(queryString);
        q.setString("searchString", sString);
        q.setFirstResult(firstResult);
        q.setMaxResults(maxResults);
        results.setCount(this.countUserAttributesMatches(searchString));
        results.setFirstResult(firstResult);
        results.setResultsPerPage(maxResults);
        results.setSearchString(searchString);
        results.setResults(q.list());
        return results;
    }

    public boolean isAttributeValueAlreadyAssigned(VOMSUser u, String attributeName, String attributeValue) {
        return this.isAttributeValueAlreadyAssigned(u, this.getAttributeDescriptionByName(attributeName), attributeValue);
    }

    public boolean isAttributeValueAlreadyAssigned(VOMSUser u, VOMSAttributeDescription desc, String attrValue) {
        if (!desc.isUnique()) {
            return false;
        }
        String queryString = "select a.value from org.glite.security.voms.admin.persistence.model.VOMSUser u join u.attributes a where a.attributeDescription = :desc and u != :user";
        Query q = HibernateFactory.getSession().createQuery(queryString);
        q.setEntity("desc", (Object)desc);
        q.setEntity("user", (Object)u);
        Iterator i = q.iterate();
        while (i.hasNext()) {
            String value = (String)i.next();
            if (value == null) {
                return false;
            }
            if (!value.equals(attrValue)) continue;
            return true;
        }
        return false;
    }

    public void update(VOMSAttributeDescription desc) {
        HibernateFactory.getSession().update((Object)desc);
    }
}

