/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.dao;

import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import org.glite.security.voms.admin.error.VOMSException;
import org.glite.security.voms.admin.persistence.HibernateFactory;
import org.glite.security.voms.admin.persistence.dao.VOMSCADAO;
import org.glite.security.voms.admin.persistence.error.NoSuchCAException;
import org.glite.security.voms.admin.persistence.model.Certificate;
import org.glite.security.voms.admin.persistence.model.VOMSCA;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.glite.security.voms.admin.util.DNUtil;

public class CertificateDAO {
    private CertificateDAO() {
        HibernateFactory.beginTransaction();
    }

    public Certificate findByDN(String dn) {
        assert (dn != null) : "Null DN passed as argument!";
        String query = "From Certificate where subjectString = :subjectString";
        List dbCerts = HibernateFactory.getSession().createQuery(query).setString("subjectString", dn).list();
        if (dbCerts.size() > 1) {
            throw new VOMSException("Multiple certificates found for the following dn '" + dn + "'. Please specify the CA dn!");
        }
        if (dbCerts.size() == 0) {
            return null;
        }
        return (Certificate)dbCerts.get(0);
    }

    public Certificate findByDNCA(String dn, String ca) {
        assert (dn != null) : "Null DN passed as argument!";
        assert (ca != null) : "Null ca passed as argument!";
        String query = "From Certificate where subjectString = :subjectString and ca.subjectString = :ca";
        Certificate dbCert = (Certificate)HibernateFactory.getSession().createQuery(query).setString("subjectString", dn).setString("ca", ca).uniqueResult();
        return dbCert;
    }

    public Certificate findById(long id) {
        return (Certificate)HibernateFactory.getSession().get(Certificate.class, (Serializable)new Long(id));
    }

    public Certificate find(X509Certificate cert) {
        assert (cert != null) : "Null certificate passed as argument!";
        String subjectString = DNUtil.getOpenSSLSubject(cert.getSubjectX500Principal());
        String query = "from Certificate where subjectString = :subjectString";
        Certificate dbCert = (Certificate)HibernateFactory.getSession().createQuery(query).setString("subjectString", subjectString).uniqueResult();
        return dbCert;
    }

    public boolean isAlreadyAssigned(X509Certificate cert) {
        Certificate dbCert = this.find(cert);
        return dbCert != null;
    }

    public Certificate create(String dn, String ca) {
        String normalizedCA = DNUtil.normalizeDN(ca);
        VOMSCA dbCA = VOMSCADAO.instance().getByName(normalizedCA);
        if (dbCA == null) {
            throw new NoSuchCAException("CA '" + ca + "' not found in database!");
        }
        Certificate cert = new Certificate();
        cert.setSubjectString(DNUtil.normalizeDN(dn));
        cert.setCa(dbCA);
        cert.setCreationTime(new Date());
        return cert;
    }

    public Certificate create(VOMSUser u, String ca) {
        Certificate cert = this.create(u.getDn(), ca);
        cert.setUser(u);
        return cert;
    }

    public List<Certificate> getForCA(VOMSCA ca) {
        assert (ca != null) : "null ca passed as argument!";
        String query = "from Certificate where ca = :ca";
        return HibernateFactory.getSession().createQuery(query).setEntity("ca", (Object)ca).list();
    }

    public List<Certificate> getAll() {
        String query = "from Certificate order by subjectString";
        return HibernateFactory.getSession().createQuery(query).list();
    }

    public static CertificateDAO instance() {
        return new CertificateDAO();
    }
}

