/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.error.VOMSFatalException;
import org.glite.security.voms.admin.persistence.error.VOMSDatabaseException;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.AnnotationConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateFactory {
    private static final Logger log = LoggerFactory.getLogger(HibernateFactory.class);
    private static final SessionFactory sessionFactory;
    private static final ThreadLocal threadSession;
    private static final ThreadLocal threadTransaction;
    private static final ThreadLocal threadInterceptor;

    public static synchronized void shutdown() {
        if (sessionFactory != null) {
            sessionFactory.close();
        }
        HibernateFactory.unregisterSQLDrivers();
        HibernateFactory.cleanupThreadLocals();
    }

    protected static void unregisterSQLDrivers() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException e) {
                log.warn("Error deregistering driver {}", (Object)driver, (Object)e);
            }
        }
    }

    protected static void cleanupThreadLocals() {
        if (threadSession != null) {
            threadSession.remove();
        }
        if (threadTransaction != null) {
            threadTransaction.remove();
        }
        if (threadInterceptor != null) {
            threadInterceptor.remove();
        }
    }

    public static SessionFactory getFactory() {
        return sessionFactory;
    }

    public static Session getSession() {
        log.debug("Getting session for thread: " + Thread.currentThread());
        Session s = (Session)threadSession.get();
        try {
            if (s == null) {
                s = sessionFactory.openSession();
                threadSession.set(s);
                log.debug("Opening new session for thread " + Thread.currentThread());
            }
        }
        catch (HibernateException ex) {
            log.error("Error getting hibernate session!", (Throwable)ex);
            throw new VOMSFatalException(ex.getMessage(), ex);
        }
        return s;
    }

    public static void closeSession() {
        try {
            Session s = (Session)threadSession.get();
            threadSession.set(null);
            if (s != null && s.isOpen()) {
                log.debug("Closing session for thread " + Thread.currentThread());
                s.close();
            }
        }
        catch (HibernateException ex) {
            log.error("Error closing hibernate session!", (Throwable)ex);
            throw new VOMSDatabaseException(ex.getMessage(), ex);
        }
    }

    public static void beginTransaction() {
        Transaction tx = (Transaction)threadTransaction.get();
        try {
            if (tx == null) {
                tx = HibernateFactory.getSession().beginTransaction();
                threadTransaction.set(tx);
            }
        }
        catch (HibernateException ex) {
            log.error("Error creating hibernate transaction!", (Throwable)ex);
            throw new VOMSDatabaseException(ex.getMessage(), ex);
        }
    }

    public static void commitTransaction() {
        Transaction tx = (Transaction)threadTransaction.get();
        try {
            if (tx != null && !tx.wasCommitted() && !tx.wasRolledBack()) {
                tx.commit();
            }
            threadTransaction.set(null);
        }
        catch (HibernateException ex) {
            HibernateFactory.rollbackTransaction();
            log.error("Error committing hibernate transaction:" + ex.getMessage());
            if (log.isDebugEnabled()) {
                log.error("Error committing hibernate transaction!", (Throwable)ex);
            }
            throw new VOMSDatabaseException(ex.getMessage(), ex);
        }
    }

    public static void rollbackTransaction() {
        Transaction tx = (Transaction)threadTransaction.get();
        try {
            threadTransaction.set(null);
            if (tx != null && !tx.wasCommitted() && !tx.wasRolledBack()) {
                tx.rollback();
            }
        }
        catch (HibernateException ex) {
            log.error("Error rolling back hibernate transaction:" + ex.getMessage());
            if (log.isDebugEnabled()) {
                log.error("Error committing hibernate transaction!", (Throwable)ex);
            }
            throw new VOMSDatabaseException(ex.getMessage(), ex);
        }
        finally {
            HibernateFactory.closeSession();
        }
    }

    static {
        threadSession = new ThreadLocal();
        threadTransaction = new ThreadLocal();
        threadInterceptor = new ThreadLocal();
        VOMSConfiguration conf = VOMSConfiguration.instance();
        try {
            AnnotationConfiguration hibernateConf = new AnnotationConfiguration();
            hibernateConf.addProperties(conf.getDatabaseProperties());
            sessionFactory = hibernateConf.configure().buildSessionFactory();
        }
        catch (HibernateException e) {
            log.error("Hibernate session factory creation failed!", (Throwable)e);
            throw new ExceptionInInitializerError(e);
        }
    }
}

