/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.users;

import org.glite.security.voms.admin.core.validation.ValidationManager;
import org.glite.security.voms.admin.error.NullArgumentException;
import org.glite.security.voms.admin.operations.BaseVomsOperation;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.persistence.dao.VOMSUserDAO;
import org.glite.security.voms.admin.persistence.model.VOMSUser;

public class SuspendUserOperation
extends BaseVomsOperation {
    VOMSUser user;
    VOMSUser.SuspensionReason reason;

    private SuspendUserOperation(Long userId, String r) {
        this.user = VOMSUserDAO.instance().findById(userId);
        this.reason = VOMSUser.SuspensionReason.OTHER;
        this.reason.setMessage(r);
    }

    private SuspendUserOperation(VOMSUser u, VOMSUser.SuspensionReason r) {
        this.user = u;
        this.reason = r;
    }

    public static SuspendUserOperation instance(Long userId, String r) {
        return new SuspendUserOperation(userId, r);
    }

    public static SuspendUserOperation instance(VOMSUser u, VOMSUser.SuspensionReason r) {
        return new SuspendUserOperation(u, r);
    }

    @Override
    protected Object doExecute() {
        if (this.user == null) {
            throw new NullArgumentException("User cannot be null!");
        }
        if (this.reason == null) {
            throw new NullArgumentException("Reason cannot be null!");
        }
        ValidationManager.instance().suspendUser(this.user, this.reason);
        return null;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(VOMSContext.getVoContext(), VOMSPermission.getContainerReadPermission().setMembershipReadPermission().setSuspendPermission());
    }
}

