/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.users;

import org.glite.security.voms.admin.error.NullArgumentException;
import org.glite.security.voms.admin.error.VOMSException;
import org.glite.security.voms.admin.operations.BaseVomsOperation;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.persistence.dao.CertificateDAO;
import org.glite.security.voms.admin.persistence.model.Certificate;
import org.glite.security.voms.admin.persistence.model.VOMSUser;

public class SuspendUserCertificateOperation
extends BaseVomsOperation {
    VOMSUser user;
    Certificate certificate;
    VOMSUser.SuspensionReason reason;

    private SuspendUserCertificateOperation(VOMSUser u, Certificate c, VOMSUser.SuspensionReason r) {
        this.user = u;
        this.certificate = c;
        this.reason = r;
    }

    public static SuspendUserCertificateOperation instance(VOMSUser u, Certificate c, VOMSUser.SuspensionReason r) {
        return new SuspendUserCertificateOperation(u, c, r);
    }

    public static SuspendUserCertificateOperation instance(String dn, String ca, String suspensionReason) {
        Certificate c = CertificateDAO.instance().findByDNCA(dn, ca);
        VOMSUser.SuspensionReason reason = VOMSUser.SuspensionReason.OTHER;
        reason.setMessage(suspensionReason);
        return new SuspendUserCertificateOperation(c.getUser(), c, reason);
    }

    @Override
    protected Object doExecute() {
        if (this.user == null) {
            throw new NullArgumentException("user cannot be null");
        }
        if (this.certificate == null) {
            throw new NullArgumentException("certificate cannot be null");
        }
        if (this.reason == null) {
            throw new NullArgumentException("reason cannot be null");
        }
        if (!this.user.hasCertificate(this.certificate)) {
            throw new VOMSException("Certificate '" + this.certificate + "' is not bound to user '" + this.user + "'.");
        }
        this.certificate.suspend(this.reason);
        return null;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(VOMSContext.getVoContext(), VOMSPermission.getContainerReadPermission().setMembershipReadPermission().setSuspendPermission());
    }
}

