/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.users;

import java.security.cert.X509Certificate;
import org.glite.security.voms.admin.operations.BaseVomsOperation;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.persistence.dao.CertificateDAO;
import org.glite.security.voms.admin.persistence.dao.VOMSUserDAO;
import org.glite.security.voms.admin.persistence.error.NoSuchCertificateException;
import org.glite.security.voms.admin.persistence.model.Certificate;

public class RemoveUserCertificateOperation
extends BaseVomsOperation {
    X509Certificate theCert;
    String subject;
    String issuer;

    private RemoveUserCertificateOperation(X509Certificate c) {
        this.theCert = c;
    }

    private RemoveUserCertificateOperation(String subject, String issuer) {
        this.subject = subject;
        this.issuer = issuer;
    }

    public static RemoveUserCertificateOperation instance(X509Certificate cert) {
        return new RemoveUserCertificateOperation(cert);
    }

    public static RemoveUserCertificateOperation instance(String subject, String issuer) {
        return new RemoveUserCertificateOperation(subject, issuer);
    }

    @Override
    protected Object doExecute() {
        if (this.theCert != null) {
            Certificate cert = CertificateDAO.instance().find(this.theCert);
            VOMSUserDAO.instance().deleteCertificate(cert);
        } else {
            Certificate cert = CertificateDAO.instance().findByDNCA(this.subject, this.issuer);
            if (cert == null) {
                throw new NoSuchCertificateException("No certificate found matching subject '" + this.subject + ", " + this.issuer + "'.");
            }
            VOMSUserDAO.instance().deleteCertificate(cert);
        }
        return null;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(VOMSContext.getVoContext(), VOMSPermission.getContainerRWPermissions().setMembershipRWPermission());
    }
}

