/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.users;

import org.glite.security.voms.admin.operations.BaseUserAdministrativeOperation;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.persistence.dao.VOMSUserDAO;

public class FindUserOperation
extends BaseUserAdministrativeOperation {
    Long id;
    String dn = null;
    String caDN = null;
    String emailAddress = null;

    private FindUserOperation(Long userId) {
        this.id = userId;
        this.setAuthorizedUser(VOMSUserDAO.instance().findById(userId));
    }

    private FindUserOperation(String dn, String ca) {
        this.dn = dn;
        this.caDN = ca;
        this.setAuthorizedUser(VOMSUserDAO.instance().findByDNandCA(dn, this.caDN));
    }

    private FindUserOperation(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    @Override
    protected Object doExecute() {
        if (this.dn == null) {
            return VOMSUserDAO.instance().findById(this.id);
        }
        if (this.emailAddress == null) {
            return VOMSUserDAO.instance().findByDNandCA(this.dn, this.caDN);
        }
        return VOMSUserDAO.instance().findByEmail(this.emailAddress);
    }

    public static FindUserOperation instance(Long id) {
        return new FindUserOperation(id);
    }

    public static FindUserOperation instance(String dn, String caDN) {
        return new FindUserOperation(dn, caDN);
    }

    public static FindUserOperation instance(String emailAddress) {
        return new FindUserOperation(emailAddress);
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(VOMSContext.getVoContext(), VOMSPermission.getContainerReadPermission().setMembershipReadPermission());
    }
}

