/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.users;

import org.glite.security.voms.admin.operations.users.RestoreUserOperation;
import org.glite.security.voms.admin.persistence.model.VOMSUser;

public class ConditionalRestoreUserOperation
extends RestoreUserOperation {
    private VOMSUser.SuspensionReason suspensionReason;

    private ConditionalRestoreUserOperation(VOMSUser u, VOMSUser.SuspensionReason suspensionReason) {
        super(u);
        this.suspensionReason = suspensionReason;
    }

    private ConditionalRestoreUserOperation(Long userId, VOMSUser.SuspensionReason suspensionReason) {
        super(userId);
        this.suspensionReason = suspensionReason;
    }

    @Override
    protected Object doExecute() {
        boolean userHasBeenRestored = false;
        if (this.user.isSuspended() && this.user.getSuspensionReason().equals((Object)this.suspensionReason)) {
            this.user.restore();
            userHasBeenRestored = true;
        }
        return userHasBeenRestored;
    }

    public static ConditionalRestoreUserOperation instance(Long userId, VOMSUser.SuspensionReason reason) {
        return new ConditionalRestoreUserOperation(userId, reason);
    }

    public static ConditionalRestoreUserOperation instance(VOMSUser u, VOMSUser.SuspensionReason reason) {
        return new ConditionalRestoreUserOperation(u, reason);
    }
}

