/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.roles;

import org.glite.security.voms.admin.error.NullArgumentException;
import org.glite.security.voms.admin.operations.BaseAttributeRWOperation;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.groups.FindGroupOperation;
import org.glite.security.voms.admin.operations.roles.FindRoleOperation;
import org.glite.security.voms.admin.persistence.dao.VOMSRoleDAO;
import org.glite.security.voms.admin.persistence.error.NoSuchGroupException;
import org.glite.security.voms.admin.persistence.error.NoSuchRoleException;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.VOMSRole;
import org.glite.security.voms.service.attributes.AttributeValue;

public class SetRoleAttributeOperation
extends BaseAttributeRWOperation {
    String attributeName;
    String attributeValue;

    @Override
    protected Object doExecute() {
        return VOMSRoleDAO.instance().setAttribute(this.__context.getRole(), this.__context.getGroup(), this.attributeName, this.attributeValue);
    }

    private SetRoleAttributeOperation(VOMSGroup g, VOMSRole r, String aName, String aValue) {
        super(VOMSContext.instance(g, r));
        this.attributeName = aName;
        this.attributeValue = aValue;
    }

    public static SetRoleAttributeOperation instance(String groupName, String roleName, AttributeValue val) {
        if (val == null) {
            throw new NullArgumentException("Null attribute value passed as argument!");
        }
        VOMSGroup g = (VOMSGroup)FindGroupOperation.instance(groupName).execute();
        VOMSRole r = (VOMSRole)FindRoleOperation.instance(roleName).execute();
        if (g == null) {
            throw new NoSuchGroupException("Group '" + groupName + "' not found!");
        }
        if (r == null) {
            throw new NoSuchRoleException("Role '" + roleName + "' not found!");
        }
        return new SetRoleAttributeOperation(g, r, val.getAttributeClass().getName(), val.getValue());
    }

    public static SetRoleAttributeOperation instance(VOMSGroup g, VOMSRole r, String aName, String aValue) {
        return new SetRoleAttributeOperation(g, r, aName, aValue);
    }
}

