/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.roles;

import org.glite.security.voms.admin.operations.BaseAttributeRWOperation;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.groups.FindGroupOperation;
import org.glite.security.voms.admin.operations.roles.FindRoleOperation;
import org.glite.security.voms.admin.persistence.dao.VOMSRoleDAO;
import org.glite.security.voms.admin.persistence.error.NoSuchGroupException;
import org.glite.security.voms.admin.persistence.error.NoSuchRoleException;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.VOMSRole;

public class DeleteRoleAttributeOperation
extends BaseAttributeRWOperation {
    String attributeName;

    @Override
    protected Object doExecute() {
        VOMSRoleDAO.instance().deleteAttributeByName(this.__context.getRole(), this.__context.getGroup(), this.attributeName);
        return null;
    }

    private DeleteRoleAttributeOperation(VOMSGroup g, VOMSRole r, String attributeName) {
        super(VOMSContext.instance(g, r));
        this.attributeName = attributeName;
    }

    public static DeleteRoleAttributeOperation instance(VOMSGroup g, VOMSRole r, String attributeName) {
        return new DeleteRoleAttributeOperation(g, r, attributeName);
    }

    public static DeleteRoleAttributeOperation instance(String groupName, String roleName, String attributeName) {
        VOMSGroup g = (VOMSGroup)FindGroupOperation.instance(groupName).execute();
        VOMSRole r = (VOMSRole)FindRoleOperation.instance(roleName).execute();
        if (g == null) {
            throw new NoSuchGroupException("Group '" + groupName + "' not found!");
        }
        if (r == null) {
            throw new NoSuchRoleException("Role '" + roleName + "' not found!");
        }
        return new DeleteRoleAttributeOperation(g, r, attributeName);
    }
}

