/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.requests;

import org.glite.security.voms.admin.event.EventManager;
import org.glite.security.voms.admin.event.registration.RoleMembershipApprovedEvent;
import org.glite.security.voms.admin.event.registration.RoleMembershipRejectedEvent;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.operations.requests.BaseHandleRequestOperation;
import org.glite.security.voms.admin.operations.requests.DECISION;
import org.glite.security.voms.admin.operations.users.AssignRoleOperation;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.VOMSRole;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.glite.security.voms.admin.persistence.model.request.Request;
import org.glite.security.voms.admin.persistence.model.request.RoleMembershipRequest;

public class HandleRoleMembershipRequestOperation
extends BaseHandleRequestOperation<RoleMembershipRequest> {
    public HandleRoleMembershipRequestOperation(RoleMembershipRequest request, DECISION decision) {
        super(request, decision);
    }

    @Override
    protected void approve() {
        this.checkRequestStatus(Request.STATUS.SUBMITTED);
        VOMSUser u = this.getRequesterAsVomsUser();
        VOMSGroup g = this.findGroupByName(((RoleMembershipRequest)this.request).getGroupName());
        VOMSRole r = this.findRoleByName(((RoleMembershipRequest)this.request).getRoleName());
        AssignRoleOperation.instance(u, g, r).execute();
        ((RoleMembershipRequest)this.request).approve();
        EventManager.dispatch(new RoleMembershipApprovedEvent((RoleMembershipRequest)this.request));
    }

    @Override
    protected void reject() {
        this.checkRequestStatus(Request.STATUS.SUBMITTED);
        ((RoleMembershipRequest)this.request).reject();
        EventManager.dispatch(new RoleMembershipRejectedEvent((RoleMembershipRequest)this.request));
    }

    @Override
    protected void setupPermissions() {
        VOMSGroup g = this.findGroupByName(((RoleMembershipRequest)this.request).getGroupName());
        VOMSRole r = this.findRoleByName(((RoleMembershipRequest)this.request).getRoleName());
        this.addRequiredPermissionOnPath(g, VOMSPermission.getContainerReadPermission());
        this.addRequiredPermission(VOMSContext.instance(g, r), VOMSPermission.getMembershipRWPermissions());
        this.addRequiredPermission(VOMSContext.instance(g, r), VOMSPermission.getRequestsRWPermissions());
    }
}

