/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.groups;

import org.glite.security.voms.admin.operations.BaseMemberhipReadOperation;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.persistence.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.persistence.dao.VOMSRoleDAO;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.VOMSRole;
import org.glite.security.voms.admin.view.actions.SearchData;

public class SearchMembersOperation
extends BaseMemberhipReadOperation {
    int firstResult = 0;
    int maxResults = 0;
    String searchString;

    private SearchMembersOperation(VOMSContext c, String searchString, int firstResult, int maxResults) {
        super(c);
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        this.searchString = searchString;
    }

    private SearchMembersOperation(VOMSGroup g, VOMSRole r, String searchString, int firstResult, int maxResults) {
        super(VOMSContext.instance(g, r));
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        this.searchString = searchString;
    }

    @Override
    protected Object doExecute() {
        if (!this.__context.isGroupContext()) {
            return VOMSRoleDAO.instance().searchMembers(this.__context.getGroup(), this.__context.getRole(), this.searchString, this.firstResult, this.maxResults);
        }
        return VOMSGroupDAO.instance().searchMembers(this.__context.getGroup(), this.searchString, this.firstResult, this.maxResults);
    }

    public static SearchMembersOperation instance(VOMSGroup g, VOMSRole r, String searchString, int firstResult, int maxResults) {
        return new SearchMembersOperation(g, r, searchString, firstResult, maxResults);
    }

    public static SearchMembersOperation instance(VOMSGroup g, String searchString, int firstResult, int maxResults) {
        return new SearchMembersOperation(g, null, searchString, firstResult, maxResults);
    }

    public static SearchMembersOperation instance(SearchData sd) {
        VOMSContext ctxt = VOMSContext.instance(sd.getGroupId(), sd.getRoleId());
        return new SearchMembersOperation(ctxt, sd.getText(), sd.getFirstResult(), sd.getMaxResults());
    }
}

