/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.groups;

import java.util.List;
import org.glite.security.voms.admin.operations.BaseVomsOperation;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.operations.groups.FindGroupOperation;
import org.glite.security.voms.admin.operations.groups.ListChildrenGroupsOperation;
import org.glite.security.voms.admin.operations.users.FindUserOperation;
import org.glite.security.voms.admin.persistence.dao.VOMSUserDAO;
import org.glite.security.voms.admin.persistence.error.NoSuchGroupException;
import org.glite.security.voms.admin.persistence.error.NoSuchUserException;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.VOMSUser;

public class RemoveMemberOperation
extends BaseVomsOperation {
    VOMSUser user;
    VOMSGroup group;

    private RemoveMemberOperation(VOMSUser u, VOMSGroup g) {
        this.user = u;
        this.group = g;
    }

    @Override
    protected Object doExecute() {
        List childrenGroups = (List)ListChildrenGroupsOperation.instance(this.group).execute();
        for (VOMSGroup childGroup : childrenGroups) {
            if (!this.user.isMember(childGroup)) continue;
            RemoveMemberOperation.instance(this.user, childGroup).execute();
        }
        VOMSUserDAO.instance().removeFromGroup(this.user, this.group);
        return null;
    }

    public static RemoveMemberOperation instance(VOMSUser u, VOMSGroup g) {
        return new RemoveMemberOperation(u, g);
    }

    public static RemoveMemberOperation instance(String groupName, String username, String caDn) {
        VOMSUser u = (VOMSUser)FindUserOperation.instance(username, caDn).execute();
        VOMSGroup g = (VOMSGroup)FindGroupOperation.instance(groupName).execute();
        if (u == null) {
            throw new NoSuchUserException("User '" + username + "," + caDn + "' not found in this vo.");
        }
        if (g == null) {
            throw new NoSuchGroupException("Group '" + groupName + "' does not exist in this vo.");
        }
        return new RemoveMemberOperation(u, g);
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(VOMSContext.instance(this.group.getParent()), VOMSPermission.getContainerReadPermission());
        this.addRequiredPermission(VOMSContext.instance(this.group), VOMSPermission.getMembershipRWPermissions().setContainerReadPermission());
    }
}

