/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.groups;

import org.glite.security.voms.admin.operations.BaseVomsOperation;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSOperation;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.persistence.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.persistence.error.NoSuchGroupException;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.util.PathNamingScheme;

public class DeleteGroupOperation
extends BaseVomsOperation {
    String groupName = null;
    Long groupId;
    VOMSGroup group;

    private DeleteGroupOperation(String groupName) {
        this.groupName = groupName;
    }

    private DeleteGroupOperation(VOMSGroup g) {
        this.group = g;
    }

    private DeleteGroupOperation(Long id) {
        this.groupId = id;
    }

    @Override
    protected Object doExecute() {
        if (this.group == null) {
            this.group = this.groupName != null ? VOMSGroupDAO.instance().findByName(this.groupName) : VOMSGroupDAO.instance().findById(this.groupId);
        }
        if (this.group == null) {
            String msg = this.groupName == null ? "Group having id '" + this.groupId + "' not found in database." : "Group '" + this.groupName + "' not found in database.";
            throw new NoSuchGroupException(msg);
        }
        VOMSGroupDAO.instance().delete(this.group);
        return this.group;
    }

    public static DeleteGroupOperation instance(String groupName) {
        return new DeleteGroupOperation(groupName);
    }

    public static VOMSOperation instance(VOMSGroup g) {
        return new DeleteGroupOperation(g);
    }

    public static VOMSOperation instance(Long id) {
        return new DeleteGroupOperation(id);
    }

    @Override
    protected void setupPermissions() {
        VOMSContext ctxt;
        if (this.group == null) {
            if (this.groupName != null) {
                String parentGroupName = PathNamingScheme.getParentGroupName(this.groupName);
                VOMSGroup parentGroup = VOMSGroupDAO.instance().findByName(parentGroupName);
                if (parentGroup == null) {
                    throw new NoSuchGroupException("Group '" + parentGroupName + "' not found in database!");
                }
                ctxt = VOMSContext.instance(parentGroup);
            } else {
                VOMSGroup g = VOMSGroupDAO.instance().findById(this.groupId);
                if (g == null) {
                    throw new NoSuchGroupException("Group having id '" + this.groupId + "' not found in database!");
                }
                ctxt = VOMSContext.instance(g.getParent());
            }
        } else {
            ctxt = VOMSContext.instance(this.group.getParent());
        }
        this.addRequiredPermission(ctxt, VOMSPermission.getContainerRWPermissions());
    }
}

