/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.groups;

import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.glite.security.voms.admin.operations.BaseVomsOperation;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.operations.roles.ListRolesOperation;
import org.glite.security.voms.admin.persistence.HibernateFactory;
import org.glite.security.voms.admin.persistence.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.VOMSRole;
import org.glite.security.voms.admin.util.PathNamingScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateGroupOperation
extends BaseVomsOperation {
    private static final Logger log = LoggerFactory.getLogger(CreateGroupOperation.class);
    String groupName;
    String groupDescription;
    Boolean restricted;

    private CreateGroupOperation(String name, String groupDescription, Boolean restricted) {
        this.groupName = name;
        this.groupDescription = groupDescription;
        this.restricted = restricted;
    }

    private CreateGroupOperation(String name) {
        this.groupName = name;
    }

    private void setupACLs(VOMSGroup g) {
        log.debug("Setting up acls for group '" + g + "'.");
        if (g.getParent().getDefaultACL() != null) {
            g.importACL(g.getParent().getDefaultACL());
        } else {
            g.importACL(g.getParent().getACL());
        }
        List roles = (List)ListRolesOperation.instance().execute();
        for (VOMSRole r : roles) {
            log.debug("Importing group '" + g + "' acl in role '" + r + "'.");
            r.importACL(g);
            HibernateFactory.getSession().save((Object)r);
        }
    }

    @Override
    protected Object doExecute() {
        VOMSGroup g = VOMSGroupDAO.instance().create(this.groupName, this.groupDescription, this.restricted);
        this.setupACLs(g);
        HibernateFactory.getSession().save((Object)g);
        return g;
    }

    public static CreateGroupOperation instance(String groupName) {
        return new CreateGroupOperation(groupName);
    }

    public static CreateGroupOperation instance(String groupName, String groupDescription, Boolean isRestricted) {
        return new CreateGroupOperation(groupName, groupDescription, isRestricted);
    }

    @Override
    protected void setupPermissions() {
        String parentGroupName = PathNamingScheme.getParentGroupName(this.groupName);
        VOMSGroup parentGroup = VOMSGroupDAO.instance().findByName(parentGroupName);
        this.addPermissionsOnPath(parentGroup, VOMSPermission.getContainerReadPermission());
        this.addRequiredPermission(VOMSContext.instance(parentGroup), VOMSPermission.getContainerRWPermissions());
        if (!parentGroup.isRootGroup()) {
            this.addRequiredPermission(VOMSContext.getVoContext(), VOMSPermission.getContainerRWPermissions());
        }
        if (log.isDebugEnabled()) {
            this.logRequiredPermissions();
        }
    }

    @Override
    protected String logArgs() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

