/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.acls;

import java.util.Map;
import org.glite.security.voms.admin.error.NullArgumentException;
import org.glite.security.voms.admin.error.VOMSException;
import org.glite.security.voms.admin.operations.BaseVomsOperation;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.persistence.model.ACL;
import org.glite.security.voms.admin.persistence.model.VOMSAdmin;

public class SetACLOperation
extends BaseVomsOperation {
    Map<VOMSAdmin, VOMSPermission> permissions;
    ACL theACL;

    private SetACLOperation(ACL acl, Map<VOMSAdmin, VOMSPermission> perms) {
        if (acl == null) {
            throw new NullArgumentException("acl cannot be null!");
        }
        if (perms == null) {
            throw new NullArgumentException("perms cannot be null!");
        }
        this.theACL = acl;
        this.permissions = perms;
    }

    public static SetACLOperation instance(ACL acl, Map<VOMSAdmin, VOMSPermission> perms) {
        return new SetACLOperation(acl, perms);
    }

    @Override
    protected Object doExecute() {
        if (this.permissions.isEmpty() && !this.theACL.isDefautlACL()) {
            throw new VOMSException("Will not replace the current ACL with an empty one.");
        }
        this.theACL.getPermissions().clear();
        this.theACL.getPermissions().putAll(this.permissions);
        return null;
    }

    @Override
    protected void setupPermissions() {
        VOMSPermission perms = VOMSPermission.getEmptyPermissions().setACLReadPermission().setACLWritePermission();
        if (this.theACL.isDefautlACL()) {
            perms.setACLDefaultPermission();
        }
        this.addRequiredPermission(this.theACL.getContext(), perms);
    }
}

