/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class VOMSPermission
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final int CONTAINER_READ = 1;
    public static final int CONTAINER_WRITE = 2;
    public static final int MEMBERSHIP_READ = 4;
    public static final int MEMBERSHIP_WRITE = 8;
    public static final int ACL_READ = 16;
    public static final int ACL_WRITE = 32;
    public static final int ACL_DEFAULT = 64;
    public static final int REQUESTS_READ = 128;
    public static final int REQUESTS_WRITE = 256;
    public static final int ATTRIBUTES_READ = 512;
    public static final int ATTRIBUTES_WRITE = 1024;
    public static final int PERSONAL_INFO_READ = 2048;
    public static final int PERSONAL_INFO_WRITE = 4096;
    public static final int SUSPEND = 8192;
    private static final int NUM_PERMISSIONS = 14;
    private static final int ALL_PERMISSION_MASK = 16383;
    private int bits = 0;

    public static String asString(int bits) {
        VOMSPermission p = new VOMSPermission(bits);
        return p.toString();
    }

    public static VOMSPermission fromBits(int bits) {
        if (bits <= 0) {
            throw new IllegalArgumentException("Permission must be a positive integer.");
        }
        VOMSPermission perm = new VOMSPermission();
        for (int i = 0; i < 14; ++i) {
            int PERM_MASK = 1 << i;
            if ((bits & PERM_MASK) != PERM_MASK) continue;
            perm.set(PERM_MASK);
        }
        return perm;
    }

    public static VOMSPermission fromString(String permString) {
        VOMSPermission perm = new VOMSPermission();
        String[] perms = StringUtils.split((String)permString, (char)'|');
        if (perms.length == 1 && perms[0].equals("")) {
            return perm;
        }
        return VOMSPermission.fromStringArray(perms);
    }

    public static VOMSPermission fromStringArray(String[] perms) {
        VOMSPermission perm = new VOMSPermission();
        for (int i = 0; i < perms.length; ++i) {
            if (perms[i].trim().equals("")) continue;
            if (perms[i].equals("CONTAINER_READ")) {
                perm.setContainerReadPermission();
                continue;
            }
            if (perms[i].equals("CONTAINER_WRITE")) {
                perm.setContainerWritePermission();
                continue;
            }
            if (perms[i].equals("MEMBERSHIP_READ")) {
                perm.setMembershipReadPermission();
                continue;
            }
            if (perms[i].equals("MEMBERSHIP_WRITE")) {
                perm.setMembershipWritePermission();
                continue;
            }
            if (perms[i].equals("ACL_READ")) {
                perm.setACLReadPermission();
                continue;
            }
            if (perms[i].equals("ACL_WRITE")) {
                perm.setACLWritePermission();
                continue;
            }
            if (perms[i].equals("ACL_DEFAULT")) {
                perm.setACLDefaultPermission();
                continue;
            }
            if (perms[i].equals("REQUESTS_READ")) {
                perm.setRequestsReadPermission();
                continue;
            }
            if (perms[i].equals("REQUESTS_WRITE")) {
                perm.setRequestsWritePermission();
                continue;
            }
            if (perms[i].equals("ATTRIBUTES_READ")) {
                perm.setAttributesReadPermission();
                continue;
            }
            if (perms[i].equals("ATTRIBUTES_WRITE")) {
                perm.setAttributesWritePermission();
                continue;
            }
            if (perms[i].equals("PERSONAL_INFO_READ")) {
                perm.setPersonalInfoReadPermission();
                continue;
            }
            if (perms[i].equals("PERSONAL_INFO_WRITE")) {
                perm.setPersonalInfoWritePermission();
                continue;
            }
            if (perms[i].equals("SUSPEND")) {
                perm.setSuspendPermission();
                continue;
            }
            if (perms[i].equals("ALL")) {
                perm.setAllPermissions();
                continue;
            }
            if (perms[i].equals("NONE")) {
                perm.setEmptyPermissions();
                continue;
            }
            throw new IllegalArgumentException("Unknown permission passed as argument: " + perms[i]);
        }
        return perm;
    }

    public static VOMSPermission getAllPermissions() {
        return new VOMSPermission().setAllPermissions();
    }

    public static VOMSPermission getAttributesRWPermissions() {
        return new VOMSPermission().setAttributesReadPermission().setAttributesWritePermission();
    }

    public static VOMSPermission getContainerReadPermission() {
        return new VOMSPermission().setContainerReadPermission();
    }

    public static VOMSPermission getContainerRWPermissions() {
        return new VOMSPermission().setContainerReadPermission().setContainerWritePermission();
    }

    public static VOMSPermission getEmptyPermissions() {
        return new VOMSPermission().setEmptyPermissions();
    }

    public static VOMSPermission getMembershipRWPermissions() {
        return new VOMSPermission().setMembershipReadPermission().setMembershipWritePermission();
    }

    public static VOMSPermission getRequestsRWPermissions() {
        return new VOMSPermission().setRequestsReadPermission().setRequestsWritePermission();
    }

    public static VOMSPermission getSuspendPermissions() {
        return new VOMSPermission().setSuspendPermission();
    }

    public VOMSPermission() {
    }

    public VOMSPermission(int bits) {
        this.bits = bits;
    }

    private List buildPermList() {
        ArrayList<String> permList = new ArrayList<String>();
        if (this.test(1)) {
            permList.add("CONTAINER_READ");
        }
        if (this.test(2)) {
            permList.add("CONTAINER_WRITE");
        }
        if (this.test(4)) {
            permList.add("MEMBERSHIP_READ");
        }
        if (this.test(8)) {
            permList.add("MEMBERSHIP_WRITE");
        }
        if (this.test(16)) {
            permList.add("ACL_READ");
        }
        if (this.test(32)) {
            permList.add("ACL_WRITE");
        }
        if (this.test(64)) {
            permList.add("ACL_DEFAULT");
        }
        if (this.test(128)) {
            permList.add("REQUESTS_READ");
        }
        if (this.test(256)) {
            permList.add("REQUESTS_WRITE");
        }
        if (this.test(512)) {
            permList.add("ATTRIBUTES_READ");
        }
        if (this.test(1024)) {
            permList.add("ATTRIBUTES_WRITE");
        }
        if (this.test(2048)) {
            permList.add("PERSONAL_INFO_READ");
        }
        if (this.test(4096)) {
            permList.add("PERSONAL_INFO_WRITE");
        }
        if (this.test(8192)) {
            permList.add("SUSPEND");
        }
        return permList;
    }

    public Object clone() throws CloneNotSupportedException {
        VOMSPermission clone = (VOMSPermission)super.clone();
        clone.bits = this.bits;
        return clone;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VOMSPermission)) {
            return false;
        }
        VOMSPermission that = (VOMSPermission)other;
        return this.bits == that.bits;
    }

    public int getBits() {
        return this.bits;
    }

    public String getCompactRepresentation() {
        StringBuffer buf = new StringBuffer();
        if (this.bits == 0) {
            return "NONE";
        }
        if (this.test(16383)) {
            return "ALL";
        }
        buf.append("C:");
        buf.append(this.test(1) ? "r" : "-");
        buf.append(this.test(2) ? "w" : "-");
        buf.append(" M:");
        buf.append(this.test(4) ? "r" : "-");
        buf.append(this.test(8) ? "w" : "-");
        buf.append(" Acl:");
        buf.append(this.test(16) ? "r" : "-");
        buf.append(this.test(32) ? "w" : "-");
        if (this.test(64)) {
            buf.append("d");
        }
        buf.append(" Attrs:");
        buf.append(this.test(512) ? "r" : "-");
        buf.append(this.test(1024) ? "w" : "-");
        buf.append(" Req:");
        buf.append(this.test(128) ? "r" : "-");
        buf.append(this.test(256) ? "w" : "-");
        buf.append(" Info:");
        buf.append(this.test(2048) ? "r" : "-");
        buf.append(this.test(4096) ? "w" : "-");
        buf.append(" Susp:");
        buf.append(this.test(8192) ? "y" : "-");
        return buf.toString();
    }

    public boolean has(String permString) {
        if (permString == null) {
            return false;
        }
        if (permString.equals("CONTAINER_READ")) {
            return this.test(1);
        }
        if (permString.equals("CONTAINER_WRITE")) {
            return this.test(2);
        }
        if (permString.equals("MEMBERSHIP_READ")) {
            return this.test(4);
        }
        if (permString.equals("MEMBERSHIP_WRITE")) {
            return this.test(8);
        }
        if (permString.equals("ACL_READ")) {
            return this.test(16);
        }
        if (permString.equals("ACL_WRITE")) {
            return this.test(32);
        }
        if (permString.equals("ACL_DEFAULT")) {
            return this.test(64);
        }
        if (permString.equals("REQUESTS_READ")) {
            return this.test(128);
        }
        if (permString.equals("REQUESTS_WRITE")) {
            return this.test(256);
        }
        if (permString.equals("ATTRIBUTES_READ")) {
            return this.test(512);
        }
        if (permString.equals("ATTRIBUTES_WRITE")) {
            return this.test(1024);
        }
        if (permString.equals("PERSONAL_INFO_READ")) {
            return this.test(2048);
        }
        if (permString.equals("PERSONAL_INFO_WRITE")) {
            return this.test(4096);
        }
        if (permString.equals("SUSPEND")) {
            return this.test(8192);
        }
        throw new IllegalArgumentException("Unknown permission passed as argument: " + permString);
    }

    public boolean hasACLDefaultPermission() {
        return this.test(64);
    }

    public boolean hasACLReadPermission() {
        return this.test(16);
    }

    public boolean hasACLWritePermission() {
        return this.test(32);
    }

    public boolean hasAttributeReadPermission() {
        return this.test(512);
    }

    public boolean hasAttributeWritePermission() {
        return this.test(1024);
    }

    public boolean hasContainerReadPermission() {
        return this.test(1);
    }

    public boolean hasContainerWritePermission() {
        return this.test(2);
    }

    public int hashCode() {
        return new Integer(this.bits).hashCode();
    }

    public boolean hasMembershipReadPermission() {
        return this.test(4);
    }

    public boolean hasMembershipWritePermission() {
        return this.test(8);
    }

    public boolean hasPersonalInfoReadPermission() {
        return this.test(2048);
    }

    public boolean hasPersonalInfoWritePermission() {
        return this.test(4096);
    }

    public boolean hasRequestReadPermission() {
        return this.test(128);
    }

    public boolean hasRequestWritePermission() {
        return this.test(256);
    }

    public boolean hasSuspendPermission() {
        return this.test(8192);
    }

    public boolean satisfies(VOMSPermission other) {
        int perms = this.bits & other.getBits();
        return perms == other.getBits();
    }

    protected VOMSPermission set(int permission) {
        if (permission <= 0) {
            throw new IllegalArgumentException("Permission must be a positive integer.");
        }
        this.bits |= permission;
        return this;
    }

    public VOMSPermission setACLDefaultPermission() {
        this.set(64);
        return this;
    }

    public VOMSPermission setACLReadPermission() {
        this.set(16);
        return this;
    }

    public VOMSPermission setACLWritePermission() {
        this.set(32);
        return this;
    }

    public VOMSPermission setAllPermissions() {
        this.set(16383);
        return this;
    }

    public VOMSPermission setAttributesReadPermission() {
        this.set(512);
        return this;
    }

    public VOMSPermission setAttributesWritePermission() {
        this.set(1024);
        return this;
    }

    public VOMSPermission setContainerReadPermission() {
        this.set(1);
        return this;
    }

    public VOMSPermission setContainerWritePermission() {
        this.set(2);
        return this;
    }

    public VOMSPermission setEmptyPermissions() {
        this.bits = 0;
        return this;
    }

    public VOMSPermission setMembershipReadPermission() {
        this.set(4);
        return this;
    }

    public VOMSPermission setMembershipRWPermission() {
        this.set(4);
        this.set(8);
        return this;
    }

    public VOMSPermission setMembershipWritePermission() {
        this.set(8);
        return this;
    }

    public VOMSPermission setPermissions(int bits) {
        this.set(bits);
        return this;
    }

    public VOMSPermission setPersonalInfoReadPermission() {
        this.set(2048);
        return this;
    }

    public VOMSPermission setPersonalInfoWritePermission() {
        this.set(4096);
        return this;
    }

    public VOMSPermission setRequestsReadPermission() {
        this.set(128);
        return this;
    }

    public VOMSPermission setRequestsWritePermission() {
        this.set(256);
        return this;
    }

    public VOMSPermission setSuspendPermission() {
        this.set(8192);
        return this;
    }

    protected boolean test(int permission) {
        if (permission <= 0) {
            throw new IllegalArgumentException("Permission must be a positive integer.");
        }
        return (this.bits & permission) == permission;
    }

    public String toBinaryString() {
        return Integer.toBinaryString(this.bits);
    }

    public String toString() {
        if (this.test(16383)) {
            return "ALL";
        }
        if (this.bits == 0) {
            return "NONE";
        }
        List permList = this.buildPermList();
        String result = StringUtils.join(permList.iterator(), (String)",");
        permList.clear();
        permList = null;
        return result;
    }

    public String[] toStringArray() {
        if (this.bits == 0) {
            return null;
        }
        List permList = this.buildPermList();
        String[] result = new String[permList.size()];
        permList.toArray(result);
        permList.clear();
        permList = null;
        return result;
    }

    public List<String> toStringList() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.bits == 0) {
            return result;
        }
        return this.buildPermList();
    }

    protected VOMSPermission unset(int permission) {
        if (permission <= 0) {
            throw new IllegalArgumentException("Permission must be a positive integer.");
        }
        this.bits &= ~permission;
        return this;
    }

    public VOMSPermission unsetACLDefaultPermission() {
        this.unset(64);
        return this;
    }

    public VOMSPermission unsetACLReadPermission() {
        this.unset(16);
        return this;
    }

    public VOMSPermission unsetACLWritePermission() {
        this.unset(32);
        return this;
    }

    public VOMSPermission unsetAttributesReadPermission() {
        this.unset(512);
        return this;
    }

    public VOMSPermission unsetAttributesWritePermission() {
        this.unset(1024);
        return this;
    }

    public VOMSPermission unsetContainerReadPermission() {
        this.unset(1);
        return this;
    }

    public VOMSPermission unsetContainerWritePermission() {
        this.unset(2);
        return this;
    }

    public VOMSPermission unsetMembershipReadPermission() {
        this.unset(4);
        return this;
    }

    public VOMSPermission unsetMembershipWritePermission() {
        this.unset(8);
        return this;
    }

    public VOMSPermission unsetRequestsReadPermission() {
        this.unset(128);
        return this;
    }

    public VOMSPermission unsetRequestsWritePermission() {
        this.unset(256);
        return this;
    }

    public void limitToPermissions(VOMSPermission limit) {
        if (limit == null) {
            return;
        }
        this.bits &= limit.getBits();
    }
}

