/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations;

import java.util.ArrayList;
import java.util.List;
import org.glite.security.voms.admin.error.VOMSException;
import org.glite.security.voms.admin.operations.VOMSOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OperationCollection {
    public static final Logger log = LoggerFactory.getLogger(OperationCollection.class);
    Class opClazz;
    List<VOMSOperation> operations;

    protected abstract void instantiateOperations() throws Exception;

    public final List<Object> execute() {
        try {
            this.instantiateOperations();
        }
        catch (Throwable e) {
            log.error("Error instantiating operation: " + e.getMessage());
            if (log.isDebugEnabled()) {
                log.error("Error instantiating operation: " + e.getMessage(), e);
            }
            throw new VOMSException("Error instantiating operation: " + e.getMessage(), e);
        }
        ArrayList<Object> returnValues = new ArrayList<Object>();
        for (VOMSOperation op : this.operations) {
            try {
                Object retVal = op.execute();
                returnValues.add(retVal);
            }
            catch (RuntimeException e) {
                log.error("Error executing operation '" + op.getName() + "' :" + e.getMessage());
                if (log.isDebugEnabled()) {
                    log.error("Error executing operation '" + op.getName() + "' :" + e.getMessage(), (Throwable)e);
                }
                throw e;
            }
        }
        return returnValues;
    }
}

