/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations;

import org.glite.security.voms.admin.operations.AuthorizationResponse;
import org.glite.security.voms.admin.operations.BaseVomsOperation;
import org.glite.security.voms.admin.operations.CurrentAdmin;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseUserAdministrativeOperation
extends BaseVomsOperation {
    public static final Logger log = LoggerFactory.getLogger(BaseUserAdministrativeOperation.class);
    protected VOMSUser authorizedUser;

    @Override
    final AuthorizationResponse isAllowed() {
        CurrentAdmin admin = CurrentAdmin.instance();
        if (!admin.isVoUser()) {
            log.debug("Current admin has no corresponding VO user, falling back to base authorization method.");
            return super.isAllowed();
        }
        boolean usersMatch = admin.getVoUser().equals(this.authorizedUser);
        log.debug("Admin's user match with authorized user: " + usersMatch);
        if (usersMatch) {
            return AuthorizationResponse.permit();
        }
        return super.isAllowed();
    }

    public VOMSUser getAuthorizedUser() {
        return this.authorizedUser;
    }

    public void setAuthorizedUser(VOMSUser authorizedUser) {
        this.authorizedUser = authorizedUser;
    }
}

