/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.notification.messages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.mail.SimpleEmail;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.notification.VOMSNotificationException;
import org.glite.security.voms.admin.persistence.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.persistence.dao.VOMSRoleDAO;
import org.glite.security.voms.admin.persistence.model.VOMSAdmin;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.VOMSRole;
import org.glite.security.voms.admin.util.PathNamingScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EmailNotification {
    private static final Logger log = LoggerFactory.getLogger(EmailNotification.class);
    List recipientList = new ArrayList();
    String subject;
    String message;
    int deliveryAttemptCount = 0;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List getRecipientList() {
        return this.recipientList;
    }

    public void setRecipientList(List recipientList) {
        this.recipientList = recipientList;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void addRecipient(String recipientAddress) {
        if (recipientAddress != null && !recipientAddress.trim().equals("")) {
            this.recipientList.add(recipientAddress);
        }
    }

    public void addRecipients(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            this.addRecipient((String)i.next());
        }
    }

    public void addAdminToRecipients(VOMSAdmin a) {
        log.debug("addAdminToRecipients::: Admin dn:" + a.getDn());
        if (!a.isInternalAdmin()) {
            this.addRecipient(a.getEmailAddress());
        } else {
            if (a.isGroupAdmin()) {
                log.debug("addAdminToRecipients::: admin is group admin.");
                this.addGroupMembersToRecipients(a.getDn());
            } else if (a.isRoleAdmin()) {
                log.debug("addAdminToRecipients::: admin is role admin.");
            }
            String groupName = PathNamingScheme.getGroupName(a.getDn());
            String roleName = PathNamingScheme.getRoleName(a.getDn());
            log.debug("GroupName: " + groupName + " RoleName:" + roleName);
            this.addRoleMembersToRecipients(groupName, roleName);
        }
    }

    public void addGroupMembersToRecipients(String groupName) {
        VOMSGroup g = VOMSGroupDAO.instance().findByName(groupName);
        this.addRecipients(g.getMembersEmailAddresses());
    }

    public void addRoleMembersToRecipients(String groupName, String roleName) {
        VOMSGroup g = VOMSGroupDAO.instance().findByName(groupName);
        VOMSRole r = VOMSRoleDAO.instance().findByName(roleName);
        if (r == null || g == null) {
            return;
        }
        this.addRecipients(r.getMembersEmailAddresses(g));
    }

    protected abstract void buildMessage();

    public void send() {
        if (this.message == null) {
            this.buildMessage();
        }
        SimpleEmail e = new SimpleEmail();
        String sender = VOMSConfiguration.instance().getString("voms.notification.email-address");
        String smtpServer = VOMSConfiguration.instance().getString("voms.notification.smtp-server");
        int smtpServerPort = VOMSConfiguration.instance().getInt("voms.notification.smtp-server.port", 25);
        String userName = VOMSConfiguration.instance().getString("voms.notification.username", null);
        String userPassword = VOMSConfiguration.instance().getString("voms.notification.password", null);
        boolean useTLS = VOMSConfiguration.instance().getBoolean("voms.notification.use_tls", false);
        ++this.deliveryAttemptCount;
        try {
            e.setHostName(smtpServer);
            e.setSmtpPort(smtpServerPort);
            e.setFrom(sender, "VOMS Admin for VO " + VOMSConfiguration.instance().getVOName());
            e.setSubject(this.subject);
            e.setMsg(this.message);
            if (userName != null && userPassword != null) {
                e.setAuthentication(userName, userPassword);
            }
            e.setTLS(useTLS);
            if (this.recipientList.isEmpty()) {
                throw new VOMSNotificationException("Empty reicipient list!");
            }
            Iterator i = this.recipientList.iterator();
            while (i.hasNext()) {
                e.addTo((String)i.next());
            }
            e.send();
        }
        catch (Throwable t) {
            log.error("Error setting up email notification!", t);
            throw new VOMSNotificationException(t.getMessage(), t);
        }
    }

    public int getDeliveryAttemptCount() {
        return this.deliveryAttemptCount;
    }

    public void setDeliveryAttemptCount(int deliveryAttemptCount) {
        this.deliveryAttemptCount = deliveryAttemptCount;
    }
}

