/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.notification.messages;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import org.glite.security.voms.admin.notification.NotificationUtil;
import org.glite.security.voms.admin.notification.messages.VelocityEmailNotification;

public abstract class AbstractVelocityNotification
extends VelocityEmailNotification {
    public static final String subjectPrefix = "[VOMS Admin]";
    VelocityContext context;
    String templatePrefix;

    public AbstractVelocityNotification() {
        this.setTemplatePrefix("/templates");
        this.context = new VelocityContext();
    }

    public void addToContext(String key, String value) {
        this.context.put(key, (Object)value);
    }

    protected void setupContext() {
        this.context.put("serviceManagementURL", (Object)NotificationUtil.getServiceURL());
    }

    @Override
    protected void buildMessage() {
        this.setupContext();
        String templateFileName = String.format("/%s/%s.vm", this.getTemplatePrefix(), this.getClass().getSimpleName());
        this.setTemplateFile(templateFileName);
        this.buildMessageFromTemplate(this.context);
    }

    public String getTemplatePrefix() {
        return this.templatePrefix;
    }

    public void setTemplatePrefix(String templatePrefix) {
        this.templatePrefix = templatePrefix;
    }

    @Override
    public void setSubject(String subject) {
        super.setSubject("[VOMS Admin] " + subject);
    }

    public String toString() {
        return "" + super.toString() + "[subject='" + this.getSubject() + "',recipients='" + StringUtils.join((Collection)this.getRecipientList(), (String)",") + "']";
    }
}

