/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.notification;

import java.util.List;
import org.glite.security.voms.admin.event.Event;
import org.glite.security.voms.admin.event.EventMask;
import org.glite.security.voms.admin.event.EventType;
import org.glite.security.voms.admin.event.registration.RoleMembershipApprovedEvent;
import org.glite.security.voms.admin.event.registration.RoleMembershipRejectedEvent;
import org.glite.security.voms.admin.event.registration.RoleMembershipRequestEvent;
import org.glite.security.voms.admin.event.registration.RoleMembershipSubmittedEvent;
import org.glite.security.voms.admin.notification.BaseNotificationDispatcher;
import org.glite.security.voms.admin.notification.NotificationService;
import org.glite.security.voms.admin.notification.NotificationUtil;
import org.glite.security.voms.admin.notification.messages.HandleRequest;
import org.glite.security.voms.admin.notification.messages.RequestApproved;
import org.glite.security.voms.admin.notification.messages.RequestRejected;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.persistence.model.request.RoleMembershipRequest;

public class RoleMembershipNotificationDispatcher
extends BaseNotificationDispatcher {
    private static RoleMembershipNotificationDispatcher instance;

    public static RoleMembershipNotificationDispatcher instance() {
        if (instance == null) {
            instance = new RoleMembershipNotificationDispatcher();
        }
        return instance;
    }

    private RoleMembershipNotificationDispatcher() {
        super(new EventMask(EventType.RoleMembershipRequestEvent));
    }

    @Override
    public void fire(Event event) {
        RoleMembershipRequestEvent e = (RoleMembershipRequestEvent)event;
        RoleMembershipRequest req = e.getRequest();
        if (e instanceof RoleMembershipSubmittedEvent) {
            RoleMembershipSubmittedEvent ee = (RoleMembershipSubmittedEvent)e;
            VOMSContext context = VOMSContext.instance(ee.getRequest().getFQAN());
            List<String> admins = NotificationUtil.getAdministratorsEmailList(context, VOMSPermission.getRequestsRWPermissions());
            HandleRequest msg = new HandleRequest(req, ee.getManagementURL(), admins);
            NotificationService.instance().send(msg);
        }
        if (e instanceof RoleMembershipApprovedEvent) {
            NotificationService.instance().send(new RequestApproved(req));
        }
        if (e instanceof RoleMembershipRejectedEvent) {
            NotificationService.instance().send(new RequestRejected(req, null));
        }
    }
}

