/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.notification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.persistence.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.persistence.dao.VOMSRoleDAO;
import org.glite.security.voms.admin.persistence.model.VOMSAdmin;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.VOMSRole;
import org.glite.security.voms.admin.util.PathNamingScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationUtil {
    public static final Logger log = LoggerFactory.getLogger(NotificationUtil.class);

    public static String getServiceURL() {
        VOMSConfiguration conf = VOMSConfiguration.instance();
        String hostname = conf.getServiceHostname();
        String voName = conf.getVOName();
        return String.format("https://%s:8443/voms/%s", hostname, voName);
    }

    public static Collection<String> resolveAdministratorEmailAddress(VOMSAdmin a) {
        HashSet<String> emails = new HashSet<String>();
        if (!a.isInternalAdmin()) {
            if (a.getEmailAddress() != null && !"".equals(a.getEmailAddress().trim())) {
                emails.add(a.getEmailAddress().trim());
            }
        } else if (a.isGroupAdmin()) {
            VOMSGroup g = VOMSGroupDAO.instance().findByName(a.getDn());
            emails.addAll(g.getMembersEmailAddresses());
        } else if (a.isRoleAdmin()) {
            VOMSRole r = VOMSRoleDAO.instance().findByName(PathNamingScheme.getRoleName(a.getDn()));
            VOMSGroup g = VOMSGroupDAO.instance().findByName(PathNamingScheme.getGroupName(a.getDn()));
            emails.addAll(r.getMembersEmailAddresses(g));
        }
        return emails;
    }

    private static String getNotificationBehaviour() {
        String[] possibleBehaviours = new String[]{"admins", "service", "all"};
        String notificationBehaviour = VOMSConfiguration.instance().getString("voms.notification.notify", "admins");
        boolean notificationBehaviourValueOK = false;
        for (String b : possibleBehaviours) {
            if (!notificationBehaviour.trim().equals(b)) continue;
            notificationBehaviourValueOK = true;
            break;
        }
        if (!notificationBehaviourValueOK) {
            notificationBehaviour = "admins";
            log.warn("Unrecognized value for configuration option: voms.notification.notify. Possible values are: 'admins','service', 'all'. Setting the default value to 'admins'. Fix your configuration file!");
        }
        return notificationBehaviour;
    }

    public static List<String> getAdministratorsEmailList() {
        return NotificationUtil.getAdministratorsEmailList(VOMSContext.getVoContext(), VOMSPermission.getAllPermissions());
    }

    public static List<String> getAdministratorsEmailList(VOMSContext context, VOMSPermission permission) {
        if (context == null) {
            throw new IllegalArgumentException("Please provide a non-null context!");
        }
        if (permission == null) {
            throw new IllegalArgumentException("Please provide a non-null permission!");
        }
        String notificationBehaviour = NotificationUtil.getNotificationBehaviour();
        String serviceEmailAddress = VOMSConfiguration.instance().getString("voms.notification.email-address");
        HashSet<String> adminEmails = new HashSet<String>();
        Set<VOMSAdmin> admins = context.getACL().getAdminsWithPermissions(permission);
        if ("admins".equals(notificationBehaviour) || "all".equals(notificationBehaviour)) {
            for (VOMSAdmin a : admins) {
                adminEmails.addAll(NotificationUtil.resolveAdministratorEmailAddress(a));
            }
            if ("service".equals(notificationBehaviour) || "all".equals(notificationBehaviour)) {
                adminEmails.add(serviceEmailAddress);
            }
            if (adminEmails.isEmpty()) {
                log.warn("No valid administrator email address found, falling back to service email address.");
                adminEmails.add(serviceEmailAddress);
            }
        }
        ArrayList<String> emailList = new ArrayList<String>();
        emailList.addAll(adminEmails);
        return emailList;
    }
}

