/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.notification;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.notification.VOMSNotificationException;
import org.glite.security.voms.admin.notification.messages.EmailNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationService {
    private static final Logger log = LoggerFactory.getLogger(NotificationService.class);
    private static NotificationService singleton = null;
    private LinkedBlockingQueue<EmailNotification> outgoingMessages = new LinkedBlockingQueue();
    private ExecutorService executorService = Executors.newSingleThreadExecutor();
    int maxDeliveryAttemptCount = VOMSConfiguration.instance().getInt("voms.noification.max_delivery_attempt_count", 5);
    long sleepTimeBeforeRetry = 30L;

    private NotificationService() {
        this.executorService.submit(new NotificationRunner(this.outgoingMessages));
    }

    public static synchronized void shutdown() {
        if (singleton == null) {
            log.debug("Notification service has not been started and, as such, cannot be shut down.");
            return;
        }
        singleton.shutdownNow();
    }

    public static synchronized NotificationService instance() {
        if (singleton == null) {
            singleton = new NotificationService();
        }
        return singleton;
    }

    public void send(EmailNotification n) {
        log.debug("Adding notification '" + n + "' to outgoing message queue.");
        if (!VOMSConfiguration.instance().getBoolean("voms.notification.disable", false)) {
            this.outgoingMessages.add(n);
        } else {
            log.warn("Outgoing notification {} will be discarded as the notification service is DISABLED.", (Object)n.toString());
        }
    }

    protected List<Runnable> shutdownNow() {
        return this.executorService.shutdownNow();
    }

    class NotificationRunner
    implements Runnable {
        final LinkedBlockingQueue<EmailNotification> outgoingQueue;

        public NotificationRunner(LinkedBlockingQueue<EmailNotification> outgoingQueue) {
            this.outgoingQueue = outgoingQueue;
        }

        @Override
        public void run() {
            while (true) {
                boolean deliveryHadErrors = false;
                try {
                    EmailNotification n = this.outgoingQueue.take();
                    log.debug("Fetched outgoing message " + n);
                    try {
                        n.send();
                        deliveryHadErrors = false;
                        log.debug("Notification '" + n + "' delivered succesfully.");
                    }
                    catch (VOMSNotificationException e) {
                        deliveryHadErrors = true;
                        log.error("Error dispatching email notification '" + n + "': " + e, (Throwable)e);
                        if (n.getDeliveryAttemptCount() < NotificationService.this.maxDeliveryAttemptCount) {
                            this.outgoingQueue.put(n);
                        } else {
                            log.warn("Discarding notification '" + n + "' after " + n.getDeliveryAttemptCount() + " failed delivery attempts.");
                        }
                    }
                    catch (Throwable t) {
                        log.error("Error dispatching email notification '" + n + "': " + t.getClass().getName() + " - " + t.getMessage());
                        if (log.isDebugEnabled()) {
                            log.error("Error dispatching email notification '" + n + "': " + t.getMessage(), t);
                        }
                        deliveryHadErrors = true;
                    }
                    if (!deliveryHadErrors || this.outgoingQueue.isEmpty()) continue;
                    TimeUnit.SECONDS.sleep(NotificationService.this.sleepTimeBeforeRetry);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }
    }
}

