/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.notification;

import java.util.List;
import org.glite.security.voms.admin.event.Event;
import org.glite.security.voms.admin.event.EventMask;
import org.glite.security.voms.admin.event.EventType;
import org.glite.security.voms.admin.event.registration.GroupMembershipApprovedEvent;
import org.glite.security.voms.admin.event.registration.GroupMembershipRejectedEvent;
import org.glite.security.voms.admin.event.registration.GroupMembershipRequestEvent;
import org.glite.security.voms.admin.event.registration.GroupMembershipSubmittedEvent;
import org.glite.security.voms.admin.notification.BaseNotificationDispatcher;
import org.glite.security.voms.admin.notification.NotificationService;
import org.glite.security.voms.admin.notification.NotificationUtil;
import org.glite.security.voms.admin.notification.messages.AbstractVelocityNotification;
import org.glite.security.voms.admin.notification.messages.HandleRequest;
import org.glite.security.voms.admin.notification.messages.RequestApproved;
import org.glite.security.voms.admin.notification.messages.RequestRejected;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.persistence.model.request.GroupMembershipRequest;

public class GroupMembershipNotificationDispatcher
extends BaseNotificationDispatcher {
    private static GroupMembershipNotificationDispatcher instance = null;

    public static GroupMembershipNotificationDispatcher instance() {
        if (instance == null) {
            instance = new GroupMembershipNotificationDispatcher();
        }
        return instance;
    }

    private GroupMembershipNotificationDispatcher() {
        super(new EventMask(EventType.GroupMembershipRequestEvent));
    }

    @Override
    public void fire(Event event) {
        AbstractVelocityNotification msg;
        GroupMembershipRequestEvent e = (GroupMembershipRequestEvent)event;
        GroupMembershipRequest req = e.getRequest();
        if (e instanceof GroupMembershipSubmittedEvent) {
            GroupMembershipSubmittedEvent ee = (GroupMembershipSubmittedEvent)e;
            VOMSContext context = VOMSContext.instance(ee.getRequest().getGroupName());
            List<String> admins = NotificationUtil.getAdministratorsEmailList(context, VOMSPermission.getRequestsRWPermissions());
            HandleRequest msg2 = new HandleRequest(req, ee.getManagementURL());
            NotificationService.instance().send(msg2);
        }
        if (e instanceof GroupMembershipApprovedEvent) {
            msg = new RequestApproved(req);
            NotificationService.instance().send(msg);
        }
        if (e instanceof GroupMembershipRejectedEvent) {
            msg = new RequestRejected(req, null);
            NotificationService.instance().send(msg);
        }
    }
}

