/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.integration.orgdb.tools;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.glite.security.voms.admin.integration.orgdb.dao.OrgDBDAOFactory;
import org.glite.security.voms.admin.integration.orgdb.dao.OrgDBVOMSPersonDAO;
import org.glite.security.voms.admin.integration.orgdb.database.OrgDBSessionFactory;
import org.glite.security.voms.admin.integration.orgdb.model.Experiment;
import org.glite.security.voms.admin.integration.orgdb.model.Institute;
import org.glite.security.voms.admin.integration.orgdb.model.Participation;
import org.glite.security.voms.admin.integration.orgdb.model.VOMSOrgDBPerson;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrgDBUtil {
    public static final String EXPERIMENT_NAME = "ATLAS";
    public static final String INSTITUTE_CODE = "077630";
    public static final Logger log = LoggerFactory.getLogger(OrgDBUtil.class);
    protected CommandLineParser parser = new PosixParser();
    protected CommandLine commandLine = null;
    protected HelpFormatter helpFormatter = new HelpFormatter();
    protected Options options = new Options();
    protected Command command;
    protected String indentSpace = "  ";

    protected void parseCommandLine(String[] args) throws ParseException {
        this.commandLine = this.parser.parse(this.options, args);
        if (this.commandLine.hasOption("h")) {
            this.printHelpMessageAndExit(0);
        }
        if (!this.commandLine.hasOption("config")) {
            log.error("Please specify the orgDb hibernate configuration using the --config option.");
            this.printHelpMessageAndExit(-1);
        }
        if (this.commandLine.getArgs().length == 0) {
            log.error("Please specify a command.");
            this.printHelpMessageAndExit(-1);
        }
        try {
            this.command = Command.valueOf(this.commandLine.getArgs()[0]);
        }
        catch (IllegalArgumentException e) {
            log.error("Unknown command: " + this.commandLine.getArgs()[0]);
            this.printHelpMessageAndExit(-1);
        }
    }

    private void printHelpMessageAndExit(int i) {
        this.helpFormatter.printHelp("OrgDBUtil", this.options);
        System.exit(i);
    }

    protected void setupCLParser() {
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"Displays helps and exits.");
        this.options.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.withLongOpt((String)"config");
        OptionBuilder.withDescription((String)"Specifies the config to be used to connect to the OrgDB");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withLongOpt((String)"email");
        OptionBuilder.withDescription((String)"Specifies the email to be used when searching/creating users.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"email"));
        OptionBuilder.withLongOpt((String)"name");
        OptionBuilder.withDescription((String)"Specifies the name to be used when searching/creating users.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"name"));
        OptionBuilder.withLongOpt((String)"surname");
        OptionBuilder.withDescription((String)"Specifies the surname to be used when searching/creating users.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"surname"));
        OptionBuilder.withLongOpt((String)"id");
        OptionBuilder.withDescription((String)"Specifies the OrgDB id to be used when searching/creating users.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"id"));
        OptionBuilder.withLongOpt((String)"institute");
        OptionBuilder.withDescription((String)"Specifies the OrgDB id to be used when searching/creating users.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"institute"));
        OptionBuilder.withLongOpt((String)"experiment");
        OptionBuilder.withDescription((String)"Specifies the OrgDB id to be used when searching/creating users.");
        OptionBuilder.hasArg();
        this.options.addOption(OptionBuilder.create((String)"experiment"));
        OptionBuilder.withLongOpt((String)"verbose");
        OptionBuilder.withDescription((String)"Produce verbose output.");
        this.options.addOption(OptionBuilder.create((String)"v"));
    }

    protected String readStringFromConsole() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        return reader.readLine();
    }

    protected void printVOMSPerson(VOMSOrgDBPerson person) {
        if (this.commandLine.hasOption("verbose")) {
            System.out.println(person);
        } else {
            System.out.printf("%d %s %s - %s\n", person.getId(), person.getFirstName(), person.getName(), person.getPhysicalEmail());
        }
        for (Participation p : person.getParticipations()) {
            if (this.commandLine.hasOption("verbose")) {
                System.out.println(p);
                continue;
            }
            System.out.printf("%s From: %s To: %s\n", p.getExperiment().getName(), p.getStartDate(), p.getEndDate());
        }
        System.out.println("\n");
    }

    protected void doListUser() {
        OrgDBVOMSPersonDAO dao = OrgDBDAOFactory.instance().getVOMSPersonDAO();
        for (VOMSOrgDBPerson p : dao.findAll()) {
            this.printVOMSPerson(p);
        }
    }

    protected void printErrorMessageAndExit(String message) {
        System.err.println(message);
        System.exit(2);
    }

    protected Long getNewVOMSPersonId(org.hibernate.Session s) {
        if (s == null || !s.isOpen()) {
            s = OrgDBSessionFactory.getSessionFactory().openSession();
        }
        Long id = (Long)s.createQuery("select max(id) from VOMSOrgDBPerson").uniqueResult();
        return id + 1L;
    }

    protected Participation cloneParticipation(Participation p) {
        Participation clone = new Participation();
        Participation.Id nId = new Participation.Id();
        nId.setExperimentId(p.getExperiment().getName());
        nId.setInstituteId(p.getInstitute().getCode());
        clone.setInstitute(p.getInstitute());
        clone.setExperiment(p.getExperiment());
        clone.setStartDate(new Date());
        clone.setEndDate(null);
        return clone;
    }

    protected VOMSOrgDBPerson clonePerson(VOMSOrgDBPerson template, Long id) {
        VOMSOrgDBPerson newPerson = new VOMSOrgDBPerson();
        newPerson.setId(id);
        newPerson.setPhysicalEmail(template.getPhysicalEmail());
        newPerson.setEmail(template.getEmail());
        newPerson.setInstitute(template.getInstitute());
        newPerson.setCernId(template.getCernId());
        newPerson.setAtCern(template.getAtCern());
        return newPerson;
    }

    protected String getValueFromConsoleIfOptionUndefined(String optionName) throws IOException {
        String value;
        if (!this.commandLine.hasOption(optionName)) {
            System.out.println("Please enter " + optionName + ":");
            value = this.readStringFromConsole();
        } else {
            value = this.commandLine.getOptionValue(optionName);
        }
        return value;
    }

    protected void updateParticipation(Participation p, Date newEndDate) {
        Session s = OrgDBSessionFactory.getSessionFactory().getCurrentSession();
        s.getTransaction();
        SQLQuery q = s.createSQLQuery("update person_participation set end_date = ? where person_id = ?");
        q.setDate(0, newEndDate);
        q.setLong(1, p.getVomsPerson().getId().longValue());
        q.executeUpdate();
        s.getTransaction().commit();
    }

    protected void createParticipation(VOMSOrgDBPerson p, Experiment e, Institute i) {
        Calendar cal = Calendar.getInstance();
        cal.add(1, -1);
        Session s = OrgDBSessionFactory.getSessionFactory().getCurrentSession();
        s.beginTransaction();
        SQLQuery q = s.createSQLQuery("insert into person_participation(EXPERIMENT,INSTITUTE,PERSON_ID,START_DATE) values(?,?,?,?)");
        q.setString(0, e.getName());
        q.setString(1, i.getCode());
        q.setLong(2, p.getId().longValue());
        q.setDate(3, cal.getTime());
        q.executeUpdate();
        s.getTransaction().commit();
    }

    protected Experiment findExperiment(String name) {
        Query q = OrgDBSessionFactory.getSessionFactory().openSession().createQuery("from Experiment where name = :name");
        return (Experiment)q.setString("name", name).uniqueResult();
    }

    protected Institute findInstitute(String code) {
        Query q = OrgDBSessionFactory.getSessionFactory().openSession().createQuery("from Institute where code = :code");
        return (Institute)q.setString("code", code).uniqueResult();
    }

    protected void doDelete() {
        if (!this.commandLine.hasOption("id")) {
            this.printErrorMessageAndExit("Please provide an id!");
        }
        System.out.println("Deleting member with id " + this.commandLine.getOptionValue("id"));
        OrgDBVOMSPersonDAO dao = OrgDBDAOFactory.instance().getVOMSPersonDAO();
        VOMSOrgDBPerson p = dao.findPersonById(Long.parseLong(this.commandLine.getOptionValue("id")));
        if (p == null) {
            this.printErrorMessageAndExit("No user found for id " + this.commandLine.getOptionValue("id"));
        }
        dao.makeTransient(p);
    }

    protected void doCreate() throws IOException {
        Institute i;
        Experiment e;
        String name = this.getValueFromConsoleIfOptionUndefined("name").trim();
        String surname = this.getValueFromConsoleIfOptionUndefined("surname").trim();
        String email = this.getValueFromConsoleIfOptionUndefined("email").trim();
        String experiment = EXPERIMENT_NAME;
        String institute = INSTITUTE_CODE;
        OrgDBVOMSPersonDAO dao = OrgDBDAOFactory.instance().getVOMSPersonDAO();
        if (dao.findPersonByEmail(email) != null) {
            this.printErrorMessageAndExit("OrgDB already have a user bound to email " + email + "!");
        }
        if ((e = this.findExperiment(experiment)) == null) {
            this.printErrorMessageAndExit("Experiment not found");
        }
        if ((i = this.findInstitute(institute)) == null) {
            this.printErrorMessageAndExit("Institute not found");
        }
        Long newId = this.getNewVOMSPersonId(null);
        VOMSOrgDBPerson newUser = new VOMSOrgDBPerson();
        newUser.setId(newId);
        newUser.setFirstName(name.toUpperCase());
        newUser.setName(surname.toUpperCase());
        newUser.setPhysicalEmail(email);
        newUser.setEmail(email);
        newUser.setAtCern("N");
        Calendar cal = Calendar.getInstance();
        cal.set(1975, 9, 15);
        newUser.setDateOfBirth(cal.getTime());
        dao.makePersistent(newUser);
        dao.flush();
        this.createParticipation(newUser, e, i);
        dao = OrgDBDAOFactory.instance().getVOMSPersonDAO();
        VOMSOrgDBPerson realNew = (VOMSOrgDBPerson)dao.findById(newId, false);
        System.out.println("Created: ");
        this.printVOMSPerson(realNew);
    }

    protected void doExpire() {
        Participation participation;
        if (!this.commandLine.hasOption("id")) {
            this.printErrorMessageAndExit("Please provide an id!");
        }
        System.out.println("Expiring member with id " + this.commandLine.getOptionValue("id"));
        OrgDBVOMSPersonDAO dao = OrgDBDAOFactory.instance().getVOMSPersonDAO();
        VOMSOrgDBPerson p = dao.findPersonById(Long.parseLong(this.commandLine.getOptionValue("id")));
        if (p == null) {
            this.printErrorMessageAndExit("No user found for id " + this.commandLine.getOptionValue("id"));
        }
        if ((participation = p.getValidParticipationForExperiment(EXPERIMENT_NAME)) == null) {
            this.printErrorMessageAndExit("No valid participation found for user " + p);
        }
        Calendar cal = Calendar.getInstance();
        cal.add(6, -1);
        Date newEnd = cal.getTime();
        this.updateParticipation(participation, newEnd);
        System.out.println("Member expired.");
        this.findAndPrintUser(p.getId());
    }

    protected void doFind() {
        VOMSOrgDBPerson p;
        if (!(this.commandLine.hasOption("email") || this.commandLine.hasOption("name") || this.commandLine.hasOption("surname") || this.commandLine.hasOption("id"))) {
            System.err.println("Please provide an email or (name,surname) for the search!");
            this.printHelpMessageAndExit(1);
        }
        OrgDBVOMSPersonDAO dao = OrgDBDAOFactory.instance().getVOMSPersonDAO();
        ArrayList<VOMSOrgDBPerson> results = new ArrayList<VOMSOrgDBPerson>();
        if (this.commandLine.hasOption("email")) {
            System.out.println("Searching for " + this.commandLine.getOptionValue("email"));
            p = dao.findPersonByEmail(this.commandLine.getOptionValue("email"));
            if (p != null) {
                results.add(p);
            }
        }
        if (this.commandLine.hasOption("name") && this.commandLine.hasOption("surname")) {
            System.out.println("Searching for " + this.commandLine.getOptionValue("name") + " " + this.commandLine.getOptionValue("surname"));
            List<VOMSOrgDBPerson> persons = dao.findPersonByName(this.commandLine.getOptionValue("name"), this.commandLine.getOptionValue("surname"));
            results.addAll(persons);
        }
        if (this.commandLine.hasOption("id")) {
            System.out.println("Searching for id " + this.commandLine.getOptionValue("id"));
            p = dao.findPersonById(Long.parseLong(this.commandLine.getOptionValue("id")));
            if (p != null) {
                results.add(p);
            }
        }
        System.out.println();
        if (results.isEmpty()) {
            System.out.println("No matches found.");
        } else {
            for (VOMSOrgDBPerson p2 : results) {
                this.printVOMSPerson(p2);
            }
        }
    }

    protected void execute() throws IOException {
        switch (this.command) {
            case list: {
                this.doListUser();
                break;
            }
            case create: {
                this.doCreate();
                break;
            }
            case expire: {
                this.doExpire();
                break;
            }
            case find: {
                this.doFind();
                break;
            }
            case restore: {
                this.doRestore();
                break;
            }
            case delete: {
                this.doDelete();
                break;
            }
            default: {
                this.printErrorMessageAndExit("Unimplemented command!");
            }
        }
    }

    public void findAndPrintUser(Long id) {
        OrgDBVOMSPersonDAO dao = OrgDBDAOFactory.instance().getVOMSPersonDAO();
        VOMSOrgDBPerson p = dao.findPersonById(id);
        if (p == null) {
            System.out.println("No user found with id " + id);
        } else {
            this.printVOMSPerson(p);
        }
    }

    public void doRestore() {
        Participation participation;
        if (!this.commandLine.hasOption("id")) {
            this.printErrorMessageAndExit("Please provide an id!");
        }
        System.out.println("Restoring member with id " + this.commandLine.getOptionValue("id"));
        OrgDBVOMSPersonDAO dao = OrgDBDAOFactory.instance().getVOMSPersonDAO();
        VOMSOrgDBPerson p = dao.findPersonById(Long.parseLong(this.commandLine.getOptionValue("id")));
        if (p == null) {
            this.printErrorMessageAndExit("No user found for id " + this.commandLine.getOptionValue("id"));
        }
        if ((participation = p.getLastExpiredParticipationForExperiment(EXPERIMENT_NAME)) == null) {
            this.printErrorMessageAndExit("No expired participations found for user " + p);
        }
        Calendar cal = Calendar.getInstance();
        cal.add(1, 1);
        Date newEnd = cal.getTime();
        this.updateParticipation(participation, newEnd);
        System.out.println("Member restored.");
        this.findAndPrintUser(p.getId());
    }

    protected void initializeDatabase() throws FileNotFoundException, IOException {
        Properties configProps = new Properties();
        configProps.load(new FileReader(this.commandLine.getOptionValue("config")));
        OrgDBSessionFactory.initialize(configProps);
    }

    public OrgDBUtil(String[] args) throws ParseException, FileNotFoundException, IOException {
        this.setupCLParser();
        this.parseCommandLine(args);
        this.initializeDatabase();
        this.execute();
        Transaction tx = OrgDBSessionFactory.getSessionFactory().getCurrentSession().getTransaction();
        if (tx.isActive() && !tx.wasCommitted()) {
            tx.commit();
        }
    }

    public static void main(String[] args) throws ParseException, FileNotFoundException, IOException {
        new OrgDBUtil(args);
    }

    static enum Command {
        list,
        find,
        create,
        expire,
        restore,
        delete;

    }
}

